package me.snowdrop.istio.mixer.adapter.fluentd;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class FluentdBuilder extends FluentdFluentImpl<FluentdBuilder> implements VisitableBuilder<Fluentd,FluentdBuilder>{

    FluentdFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public FluentdBuilder(){
            this(true);
    }
    public FluentdBuilder(Boolean validationEnabled){
            this(new Fluentd(), validationEnabled);
    }
    public FluentdBuilder(FluentdFluent<?> fluent){
            this(fluent, true);
    }
    public FluentdBuilder(FluentdFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Fluentd(), validationEnabled);
    }
    public FluentdBuilder(FluentdFluent<?> fluent,Fluentd instance){
            this(fluent, instance, true);
    }
    public FluentdBuilder(FluentdFluent<?> fluent,Fluentd instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withSpec(instance.getSpec()); 
            this.validationEnabled = validationEnabled; 
    }
    public FluentdBuilder(Fluentd instance){
            this(instance,true);
    }
    public FluentdBuilder(Fluentd instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
            this.validationEnabled = validationEnabled; 
    }
    public FluentdBuilder(Validator validator){
            this(new Fluentd(), true);
    }
    public FluentdBuilder(FluentdFluent<?> fluent,Fluentd instance,Validator validator){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withSpec(instance.getSpec()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public FluentdBuilder(Fluentd instance,Validator validator){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public Fluentd build(){
            Fluentd buildable = new Fluentd(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            FluentdBuilder that = (FluentdBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
