package me.snowdrop.istio.mixer.adapter.fluentd;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import javax.validation.Valid;
import java.lang.Boolean;

public interface FluentdFluent<A extends FluentdFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public FluentdFluent.MetadataNested<A> withNewMetadata();
    public FluentdFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public FluentdFluent.MetadataNested<A> editMetadata();
    public FluentdFluent.MetadataNested<A> editOrNewMetadata();
    public FluentdFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public FluentdSpec getSpec();
    public FluentdSpec buildSpec();
    public A withSpec(FluentdSpec spec);
    public Boolean hasSpec();
    public A withNewSpec(String address,Boolean integerDuration);
    public FluentdFluent.SpecNested<A> withNewSpec();
    public FluentdFluent.SpecNested<A> withNewSpecLike(FluentdSpec item);
    public FluentdFluent.SpecNested<A> editSpec();
    public FluentdFluent.SpecNested<A> editOrNewSpec();
    public FluentdFluent.SpecNested<A> editOrNewSpecLike(FluentdSpec item);

    public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<FluentdFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SpecNested<N> extends Nested<N>,FluentdSpecFluent<FluentdFluent.SpecNested<N>>{

        
    public N and();    public N endSpec();
}


}
