package me.snowdrop.istio.mixer.adapter.fluentd;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.Deprecated;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class FluentdListFluentImpl<A extends FluentdListFluent<A>> extends BaseFluent<A> implements FluentdListFluent<A>{

    private String apiVersion;
    private List<FluentdBuilder> items;
    private String kind;
    private ListMeta metadata;

    public FluentdListFluentImpl(){
    }
    public FluentdListFluentImpl(FluentdList instance){
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion(){
            return this.apiVersion != null;
    }

    public A addToItems(int index,Fluentd item){
            if (this.items == null) {this.items = new ArrayList<FluentdBuilder>();}
            FluentdBuilder builder = new FluentdBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
    }

    public A setToItems(int index,Fluentd item){
            if (this.items == null) {this.items = new ArrayList<FluentdBuilder>();}
            FluentdBuilder builder = new FluentdBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
             return (A)this;
    }

    public A addToItems(Fluentd... items){
            if (this.items == null) {this.items = new ArrayList<FluentdBuilder>();}
            for (Fluentd item : items) {FluentdBuilder builder = new FluentdBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A addAllToItems(Collection<Fluentd> items){
            if (this.items == null) {this.items = new ArrayList<FluentdBuilder>();}
            for (Fluentd item : items) {FluentdBuilder builder = new FluentdBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromItems(Fluentd... items){
            for (Fluentd item : items) {FluentdBuilder builder = new FluentdBuilder(item);_visitables.remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
    }

    public A removeAllFromItems(Collection<Fluentd> items){
            for (Fluentd item : items) {FluentdBuilder builder = new FluentdBuilder(item);_visitables.remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<Fluentd> getItems(){
            return build(items);
    }

    public List<Fluentd> buildItems(){
            return build(items);
    }

    public Fluentd buildItem(int index){
            return this.items.get(index).build();
    }

    public Fluentd buildFirstItem(){
            return this.items.get(0).build();
    }

    public Fluentd buildLastItem(){
            return this.items.get(items.size() - 1).build();
    }

    public Fluentd buildMatchingItem(Predicate<FluentdBuilder> predicate){
            for (FluentdBuilder item: items) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public A withItems(List<Fluentd> items){
            if (this.items != null) { _visitables.removeAll(this.items);}
            if (items != null) {this.items = new ArrayList<FluentdBuilder>(); for (Fluentd item : items){this.addToItems(item);}} else { this.items = null;} return (A) this;
    }

    public A withItems(Fluentd... items){
            if (this.items != null) {this.items.clear();}
            if (items != null) {for (Fluentd item :items){ this.addToItems(item);}} return (A) this;
    }

    public Boolean hasItems(){
            return items != null && !items.isEmpty();
    }

    public FluentdListFluent.ItemsNested<A> addNewItem(){
            return new ItemsNestedImpl();
    }

    public FluentdListFluent.ItemsNested<A> addNewItemLike(Fluentd item){
            return new ItemsNestedImpl(-1, item);
    }

    public FluentdListFluent.ItemsNested<A> setNewItemLike(int index,Fluentd item){
            return new ItemsNestedImpl(index, item);
    }

    public FluentdListFluent.ItemsNested<A> editItem(int index){
            if (items.size() <= index) throw new RuntimeException("Can't edit items. Index exceeds size.");
            return setNewItemLike(index, buildItem(index));
    }

    public FluentdListFluent.ItemsNested<A> editFirstItem(){
            if (items.size() == 0) throw new RuntimeException("Can't edit first items. The list is empty.");
            return setNewItemLike(0, buildItem(0));
    }

    public FluentdListFluent.ItemsNested<A> editLastItem(){
            int index = items.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last items. The list is empty.");
            return setNewItemLike(index, buildItem(index));
    }

    public FluentdListFluent.ItemsNested<A> editMatchingItem(Predicate<FluentdBuilder> predicate){
            int index = -1;
            for (int i=0;i<items.size();i++) { 
            if (predicate.apply(items.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching items. No match found.");
            return setNewItemLike(index, buildItem(index));
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public Boolean hasKind(){
            return this.kind != null;
    }

    public ListMeta getMetadata(){
            return this.metadata;
    }

    public A withMetadata(ListMeta metadata){
            this.metadata=metadata; return (A) this;
    }

    public Boolean hasMetadata(){
            return this.metadata != null;
    }

    public A withNewMetadata(String _continue,String resourceVersion,String selfLink){
            return (A)withMetadata(new ListMeta(_continue, resourceVersion, selfLink));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            FluentdListFluentImpl that = (FluentdListFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (items != null ? !items.equals(that.items) :that.items != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
            return true;
    }


    public class ItemsNestedImpl<N> extends FluentdFluentImpl<FluentdListFluent.ItemsNested<N>> implements FluentdListFluent.ItemsNested<N>,Nested<N>{

            private final FluentdBuilder builder;
        private final int index;
    
            ItemsNestedImpl(int index,Fluentd item){
                    this.index = index;
                    this.builder = new FluentdBuilder(this, item);
            }
            ItemsNestedImpl(){
                    this.index = -1;
                    this.builder = new FluentdBuilder(this);
            }
    
    public N and(){
            return (N) FluentdListFluentImpl.this.setToItems(index, builder.build());
    }
    public N endItem(){
            return and();
    }

}


}
