package me.snowdrop.istio.mixer.adapter.kubernetesenv;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class KubernetesenvSpecFluentImpl<A extends KubernetesenvSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements KubernetesenvSpecFluent<A>{

    private Long cacheRefreshDuration;
    private String kubeconfigPath;

    public KubernetesenvSpecFluentImpl(){
    }
    public KubernetesenvSpecFluentImpl(KubernetesenvSpec instance){
            this.withCacheRefreshDuration(instance.getCacheRefreshDuration()); 
            this.withKubeconfigPath(instance.getKubeconfigPath()); 
    }

    public Long getCacheRefreshDuration(){
            return this.cacheRefreshDuration;
    }

    public A withCacheRefreshDuration(Long cacheRefreshDuration){
            this.cacheRefreshDuration=cacheRefreshDuration; return (A) this;
    }

    public Boolean hasCacheRefreshDuration(){
            return this.cacheRefreshDuration != null;
    }

    public A withNewCacheRefreshDuration(String arg1){
            return (A)withCacheRefreshDuration(new Long(arg1));
    }

    public A withNewCacheRefreshDuration(long arg1){
            return (A)withCacheRefreshDuration(new Long(arg1));
    }

    public String getKubeconfigPath(){
            return this.kubeconfigPath;
    }

    public A withKubeconfigPath(String kubeconfigPath){
            this.kubeconfigPath=kubeconfigPath; return (A) this;
    }

    public Boolean hasKubeconfigPath(){
            return this.kubeconfigPath != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            KubernetesenvSpecFluentImpl that = (KubernetesenvSpecFluentImpl) o;
            if (cacheRefreshDuration != null ? !cacheRefreshDuration.equals(that.cacheRefreshDuration) :that.cacheRefreshDuration != null) return false;
            if (kubeconfigPath != null ? !kubeconfigPath.equals(that.kubeconfigPath) :that.kubeconfigPath != null) return false;
            return true;
    }




}
