package me.snowdrop.istio.mixer.adapter.memquota;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class QuotaBuilder extends QuotaFluentImpl<QuotaBuilder> implements VisitableBuilder<Quota,QuotaBuilder>{

    QuotaFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public QuotaBuilder(){
            this(true);
    }
    public QuotaBuilder(Boolean validationEnabled){
            this(new Quota(), validationEnabled);
    }
    public QuotaBuilder(QuotaFluent<?> fluent){
            this(fluent, true);
    }
    public QuotaBuilder(QuotaFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Quota(), validationEnabled);
    }
    public QuotaBuilder(QuotaFluent<?> fluent,Quota instance){
            this(fluent, instance, true);
    }
    public QuotaBuilder(QuotaFluent<?> fluent,Quota instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withMaxAmount(instance.getMaxAmount()); 
            fluent.withName(instance.getName()); 
            fluent.withOverrides(instance.getOverrides()); 
            fluent.withValidDuration(instance.getValidDuration()); 
            this.validationEnabled = validationEnabled; 
    }
    public QuotaBuilder(Quota instance){
            this(instance,true);
    }
    public QuotaBuilder(Quota instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withMaxAmount(instance.getMaxAmount()); 
            this.withName(instance.getName()); 
            this.withOverrides(instance.getOverrides()); 
            this.withValidDuration(instance.getValidDuration()); 
            this.validationEnabled = validationEnabled; 
    }
    public QuotaBuilder(Validator validator){
            this(new Quota(), true);
    }
    public QuotaBuilder(QuotaFluent<?> fluent,Quota instance,Validator validator){
            this.fluent = fluent; 
            fluent.withMaxAmount(instance.getMaxAmount()); 
            fluent.withName(instance.getName()); 
            fluent.withOverrides(instance.getOverrides()); 
            fluent.withValidDuration(instance.getValidDuration()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public QuotaBuilder(Quota instance,Validator validator){
            this.fluent = this; 
            this.withMaxAmount(instance.getMaxAmount()); 
            this.withName(instance.getName()); 
            this.withOverrides(instance.getOverrides()); 
            this.withValidDuration(instance.getValidDuration()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public Quota build(){
            Quota buildable = new Quota(fluent.getMaxAmount(),fluent.getName(),fluent.getOverrides(),fluent.getValidDuration());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            QuotaBuilder that = (QuotaBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
