package me.snowdrop.istio.mixer.adapter.prometheus;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class ExponentialBucketsDefinitionBuilder extends ExponentialBucketsDefinitionFluentImpl<ExponentialBucketsDefinitionBuilder> implements VisitableBuilder<ExponentialBucketsDefinition,ExponentialBucketsDefinitionBuilder>{

    ExponentialBucketsDefinitionFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public ExponentialBucketsDefinitionBuilder(){
            this(true);
    }
    public ExponentialBucketsDefinitionBuilder(Boolean validationEnabled){
            this(new ExponentialBucketsDefinition(), validationEnabled);
    }
    public ExponentialBucketsDefinitionBuilder(ExponentialBucketsDefinitionFluent<?> fluent){
            this(fluent, true);
    }
    public ExponentialBucketsDefinitionBuilder(ExponentialBucketsDefinitionFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ExponentialBucketsDefinition(), validationEnabled);
    }
    public ExponentialBucketsDefinitionBuilder(ExponentialBucketsDefinitionFluent<?> fluent,ExponentialBucketsDefinition instance){
            this(fluent, instance, true);
    }
    public ExponentialBucketsDefinitionBuilder(ExponentialBucketsDefinitionFluent<?> fluent,ExponentialBucketsDefinition instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withExponentialBuckets(instance.getExponentialBuckets()); 
            this.validationEnabled = validationEnabled; 
    }
    public ExponentialBucketsDefinitionBuilder(ExponentialBucketsDefinition instance){
            this(instance,true);
    }
    public ExponentialBucketsDefinitionBuilder(ExponentialBucketsDefinition instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withExponentialBuckets(instance.getExponentialBuckets()); 
            this.validationEnabled = validationEnabled; 
    }
    public ExponentialBucketsDefinitionBuilder(Validator validator){
            this(new ExponentialBucketsDefinition(), true);
    }
    public ExponentialBucketsDefinitionBuilder(ExponentialBucketsDefinitionFluent<?> fluent,ExponentialBucketsDefinition instance,Validator validator){
            this.fluent = fluent; 
            fluent.withExponentialBuckets(instance.getExponentialBuckets()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public ExponentialBucketsDefinitionBuilder(ExponentialBucketsDefinition instance,Validator validator){
            this.fluent = this; 
            this.withExponentialBuckets(instance.getExponentialBuckets()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public ExponentialBucketsDefinition build(){
            ExponentialBucketsDefinition buildable = new ExponentialBucketsDefinition(fluent.getExponentialBuckets());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ExponentialBucketsDefinitionBuilder that = (ExponentialBucketsDefinitionBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
