package me.snowdrop.istio.mixer.adapter.prometheus;

import java.lang.Integer;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.lang.Double;

public class LinearFluentImpl<A extends LinearFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements LinearFluent<A>{

    private Integer numFiniteBuckets;
    private Double offset;
    private Double width;

    public LinearFluentImpl(){
    }
    public LinearFluentImpl(Linear instance){
            this.withNumFiniteBuckets(instance.getNumFiniteBuckets()); 
            this.withOffset(instance.getOffset()); 
            this.withWidth(instance.getWidth()); 
    }

    public Integer getNumFiniteBuckets(){
            return this.numFiniteBuckets;
    }

    public A withNumFiniteBuckets(Integer numFiniteBuckets){
            this.numFiniteBuckets=numFiniteBuckets; return (A) this;
    }

    public Boolean hasNumFiniteBuckets(){
            return this.numFiniteBuckets != null;
    }

    public A withNewNumFiniteBuckets(String arg1){
            return (A)withNumFiniteBuckets(new Integer(arg1));
    }

    public A withNewNumFiniteBuckets(int arg1){
            return (A)withNumFiniteBuckets(new Integer(arg1));
    }

    public Double getOffset(){
            return this.offset;
    }

    public A withOffset(Double offset){
            this.offset=offset; return (A) this;
    }

    public Boolean hasOffset(){
            return this.offset != null;
    }

    public A withNewOffset(String arg1){
            return (A)withOffset(new Double(arg1));
    }

    public A withNewOffset(double arg1){
            return (A)withOffset(new Double(arg1));
    }

    public Double getWidth(){
            return this.width;
    }

    public A withWidth(Double width){
            this.width=width; return (A) this;
    }

    public Boolean hasWidth(){
            return this.width != null;
    }

    public A withNewWidth(String arg1){
            return (A)withWidth(new Double(arg1));
    }

    public A withNewWidth(double arg1){
            return (A)withWidth(new Double(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            LinearFluentImpl that = (LinearFluentImpl) o;
            if (numFiniteBuckets != null ? !numFiniteBuckets.equals(that.numFiniteBuckets) :that.numFiniteBuckets != null) return false;
            if (offset != null ? !offset.equals(that.offset) :that.offset != null) return false;
            if (width != null ? !width.equals(that.width) :that.width != null) return false;
            return true;
    }




}
