package me.snowdrop.istio.mixer.adapter.prometheus;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class MetricInfoBuilder extends me.snowdrop.istio.mixer.adapter.prometheus.MetricInfoFluentImpl<me.snowdrop.istio.mixer.adapter.prometheus.MetricInfoBuilder> implements VisitableBuilder<me.snowdrop.istio.mixer.adapter.prometheus.MetricInfo,me.snowdrop.istio.mixer.adapter.prometheus.MetricInfoBuilder>{

    me.snowdrop.istio.mixer.adapter.prometheus.MetricInfoFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public MetricInfoBuilder(){
            this(true);
    }
    public MetricInfoBuilder(Boolean validationEnabled){
            this(new MetricInfo(), validationEnabled);
    }
    public MetricInfoBuilder(me.snowdrop.istio.mixer.adapter.prometheus.MetricInfoFluent<?> fluent){
            this(fluent, true);
    }
    public MetricInfoBuilder(me.snowdrop.istio.mixer.adapter.prometheus.MetricInfoFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new MetricInfo(), validationEnabled);
    }
    public MetricInfoBuilder(me.snowdrop.istio.mixer.adapter.prometheus.MetricInfoFluent<?> fluent,me.snowdrop.istio.mixer.adapter.prometheus.MetricInfo instance){
            this(fluent, instance, true);
    }
    public MetricInfoBuilder(me.snowdrop.istio.mixer.adapter.prometheus.MetricInfoFluent<?> fluent,me.snowdrop.istio.mixer.adapter.prometheus.MetricInfo instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withBuckets(instance.getBuckets()); 
            fluent.withDescription(instance.getDescription()); 
            fluent.withInstanceName(instance.getInstanceName()); 
            fluent.withKind(instance.getKind()); 
            fluent.withLabelNames(instance.getLabelNames()); 
            fluent.withName(instance.getName()); 
            fluent.withNamespace(instance.getNamespace()); 
            this.validationEnabled = validationEnabled; 
    }
    public MetricInfoBuilder(me.snowdrop.istio.mixer.adapter.prometheus.MetricInfo instance){
            this(instance,true);
    }
    public MetricInfoBuilder(me.snowdrop.istio.mixer.adapter.prometheus.MetricInfo instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withBuckets(instance.getBuckets()); 
            this.withDescription(instance.getDescription()); 
            this.withInstanceName(instance.getInstanceName()); 
            this.withKind(instance.getKind()); 
            this.withLabelNames(instance.getLabelNames()); 
            this.withName(instance.getName()); 
            this.withNamespace(instance.getNamespace()); 
            this.validationEnabled = validationEnabled; 
    }
    public MetricInfoBuilder(Validator validator){
            this(new MetricInfo(), true);
    }
    public MetricInfoBuilder(me.snowdrop.istio.mixer.adapter.prometheus.MetricInfoFluent<?> fluent,me.snowdrop.istio.mixer.adapter.prometheus.MetricInfo instance,Validator validator){
            this.fluent = fluent; 
            fluent.withBuckets(instance.getBuckets()); 
            fluent.withDescription(instance.getDescription()); 
            fluent.withInstanceName(instance.getInstanceName()); 
            fluent.withKind(instance.getKind()); 
            fluent.withLabelNames(instance.getLabelNames()); 
            fluent.withName(instance.getName()); 
            fluent.withNamespace(instance.getNamespace()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public MetricInfoBuilder(me.snowdrop.istio.mixer.adapter.prometheus.MetricInfo instance,Validator validator){
            this.fluent = this; 
            this.withBuckets(instance.getBuckets()); 
            this.withDescription(instance.getDescription()); 
            this.withInstanceName(instance.getInstanceName()); 
            this.withKind(instance.getKind()); 
            this.withLabelNames(instance.getLabelNames()); 
            this.withName(instance.getName()); 
            this.withNamespace(instance.getNamespace()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public me.snowdrop.istio.mixer.adapter.prometheus.MetricInfo build(){
            MetricInfo buildable = new MetricInfo(fluent.getBuckets(),fluent.getDescription(),fluent.getInstanceName(),fluent.getKind(),fluent.getLabelNames(),fluent.getName(),fluent.getNamespace());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            MetricInfoBuilder that = (MetricInfoBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
