
package me.snowdrop.istio.mixer.adapter.prometheus;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "expiryCheckIntervalDuration",
    "metricsExpiryDuration"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = true, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class MetricsExpirationPolicy implements Serializable
{

    /**
     * 
     * 
     */
    @JsonProperty("expiryCheckIntervalDuration")
    @JsonPropertyDescription("")
    private Long expiryCheckIntervalDuration;
    /**
     * 
     * 
     */
    @JsonProperty("metricsExpiryDuration")
    @JsonPropertyDescription("")
    private Long metricsExpiryDuration;
    private final static long serialVersionUID = 7511814295371895694L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public MetricsExpirationPolicy() {
    }

    /**
     * 
     * @param expiryCheckIntervalDuration
     * @param metricsExpiryDuration
     */
    public MetricsExpirationPolicy(Long expiryCheckIntervalDuration, Long metricsExpiryDuration) {
        super();
        this.expiryCheckIntervalDuration = expiryCheckIntervalDuration;
        this.metricsExpiryDuration = metricsExpiryDuration;
    }

    /**
     * 
     * 
     */
    @JsonProperty("expiryCheckIntervalDuration")
    public Long getExpiryCheckIntervalDuration() {
        return expiryCheckIntervalDuration;
    }

    /**
     * 
     * 
     */
    @JsonProperty("expiryCheckIntervalDuration")
    public void setExpiryCheckIntervalDuration(Long expiryCheckIntervalDuration) {
        this.expiryCheckIntervalDuration = expiryCheckIntervalDuration;
    }

    /**
     * 
     * 
     */
    @JsonProperty("metricsExpiryDuration")
    public Long getMetricsExpiryDuration() {
        return metricsExpiryDuration;
    }

    /**
     * 
     * 
     */
    @JsonProperty("metricsExpiryDuration")
    public void setMetricsExpiryDuration(Long metricsExpiryDuration) {
        this.metricsExpiryDuration = metricsExpiryDuration;
    }

}
