package me.snowdrop.istio.mixer.adapter.prometheus;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.Deprecated;
import javax.validation.Valid;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;

public interface PrometheusListFluent<A extends PrometheusListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A addToItems(int index,Prometheus item);
    public A setToItems(int index,Prometheus item);
    public A addToItems(Prometheus... items);
    public A addAllToItems(Collection<Prometheus> items);
    public A removeFromItems(Prometheus... items);
    public A removeAllFromItems(Collection<Prometheus> items);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<Prometheus> getItems();
    public List<Prometheus> buildItems();
    public Prometheus buildItem(int index);
    public Prometheus buildFirstItem();
    public Prometheus buildLastItem();
    public Prometheus buildMatchingItem(Predicate<PrometheusBuilder> predicate);
    public A withItems(List<Prometheus> items);
    public A withItems(Prometheus... items);
    public Boolean hasItems();
    public PrometheusListFluent.ItemsNested<A> addNewItem();
    public PrometheusListFluent.ItemsNested<A> addNewItemLike(Prometheus item);
    public PrometheusListFluent.ItemsNested<A> setNewItemLike(int index,Prometheus item);
    public PrometheusListFluent.ItemsNested<A> editItem(int index);
    public PrometheusListFluent.ItemsNested<A> editFirstItem();
    public PrometheusListFluent.ItemsNested<A> editLastItem();
    public PrometheusListFluent.ItemsNested<A> editMatchingItem(Predicate<PrometheusBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends Nested<N>,PrometheusFluent<PrometheusListFluent.ItemsNested<N>>{

        
    public N and();    public N endItem();
}


}
