package me.snowdrop.istio.mixer.adapter.rbac;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class RbacListBuilder extends RbacListFluentImpl<RbacListBuilder> implements VisitableBuilder<RbacList,RbacListBuilder>{

    RbacListFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public RbacListBuilder(){
            this(true);
    }
    public RbacListBuilder(Boolean validationEnabled){
            this(new RbacList(), validationEnabled);
    }
    public RbacListBuilder(RbacListFluent<?> fluent){
            this(fluent, true);
    }
    public RbacListBuilder(RbacListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new RbacList(), validationEnabled);
    }
    public RbacListBuilder(RbacListFluent<?> fluent,RbacList instance){
            this(fluent, instance, true);
    }
    public RbacListBuilder(RbacListFluent<?> fluent,RbacList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withItems(instance.getItems()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public RbacListBuilder(RbacList instance){
            this(instance,true);
    }
    public RbacListBuilder(RbacList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public RbacListBuilder(Validator validator){
            this(new RbacList(), true);
    }
    public RbacListBuilder(RbacListFluent<?> fluent,RbacList instance,Validator validator){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withItems(instance.getItems()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public RbacListBuilder(RbacList instance,Validator validator){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public RbacList build(){
            RbacList buildable = new RbacList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            RbacListBuilder that = (RbacListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
