package me.snowdrop.istio.mixer.adapter.rbac;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class RbacSpecBuilder extends RbacSpecFluentImpl<RbacSpecBuilder> implements VisitableBuilder<RbacSpec,RbacSpecBuilder>{

    RbacSpecFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public RbacSpecBuilder(){
            this(true);
    }
    public RbacSpecBuilder(Boolean validationEnabled){
            this(new RbacSpec(), validationEnabled);
    }
    public RbacSpecBuilder(RbacSpecFluent<?> fluent){
            this(fluent, true);
    }
    public RbacSpecBuilder(RbacSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new RbacSpec(), validationEnabled);
    }
    public RbacSpecBuilder(RbacSpecFluent<?> fluent,RbacSpec instance){
            this(fluent, instance, true);
    }
    public RbacSpecBuilder(RbacSpecFluent<?> fluent,RbacSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withCacheDuration(instance.getCacheDuration()); 
            fluent.withConfigStoreUrl(instance.getConfigStoreUrl()); 
            this.validationEnabled = validationEnabled; 
    }
    public RbacSpecBuilder(RbacSpec instance){
            this(instance,true);
    }
    public RbacSpecBuilder(RbacSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withCacheDuration(instance.getCacheDuration()); 
            this.withConfigStoreUrl(instance.getConfigStoreUrl()); 
            this.validationEnabled = validationEnabled; 
    }
    public RbacSpecBuilder(Validator validator){
            this(new RbacSpec(), true);
    }
    public RbacSpecBuilder(RbacSpecFluent<?> fluent,RbacSpec instance,Validator validator){
            this.fluent = fluent; 
            fluent.withCacheDuration(instance.getCacheDuration()); 
            fluent.withConfigStoreUrl(instance.getConfigStoreUrl()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public RbacSpecBuilder(RbacSpec instance,Validator validator){
            this.fluent = this; 
            this.withCacheDuration(instance.getCacheDuration()); 
            this.withConfigStoreUrl(instance.getConfigStoreUrl()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public RbacSpec build(){
            RbacSpec buildable = new RbacSpec(fluent.getCacheDuration(),fluent.getConfigStoreUrl());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            RbacSpecBuilder that = (RbacSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
