package me.snowdrop.istio.mixer.adapter.rbac;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class RbacSpecFluentImpl<A extends RbacSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements RbacSpecFluent<A>{

    private Long cacheDuration;
    private String configStoreUrl;

    public RbacSpecFluentImpl(){
    }
    public RbacSpecFluentImpl(RbacSpec instance){
            this.withCacheDuration(instance.getCacheDuration()); 
            this.withConfigStoreUrl(instance.getConfigStoreUrl()); 
    }

    public Long getCacheDuration(){
            return this.cacheDuration;
    }

    public A withCacheDuration(Long cacheDuration){
            this.cacheDuration=cacheDuration; return (A) this;
    }

    public Boolean hasCacheDuration(){
            return this.cacheDuration != null;
    }

    public A withNewCacheDuration(String arg1){
            return (A)withCacheDuration(new Long(arg1));
    }

    public A withNewCacheDuration(long arg1){
            return (A)withCacheDuration(new Long(arg1));
    }

    public String getConfigStoreUrl(){
            return this.configStoreUrl;
    }

    public A withConfigStoreUrl(String configStoreUrl){
            this.configStoreUrl=configStoreUrl; return (A) this;
    }

    public Boolean hasConfigStoreUrl(){
            return this.configStoreUrl != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            RbacSpecFluentImpl that = (RbacSpecFluentImpl) o;
            if (cacheDuration != null ? !cacheDuration.equals(that.cacheDuration) :that.cacheDuration != null) return false;
            if (configStoreUrl != null ? !configStoreUrl.equals(that.configStoreUrl) :that.configStoreUrl != null) return false;
            return true;
    }




}
