
package me.snowdrop.istio.mixer.adapter.solarwinds;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "labelNames"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = true, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class MetricInfo implements Serializable
{

    /**
     * 
     * 
     */
    @JsonProperty("labelNames")
    @JsonPropertyDescription("")
    @Valid
    private List<String> labelNames = new ArrayList<String>();
    private final static long serialVersionUID = 4520788413565905541L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public MetricInfo() {
    }

    /**
     * 
     * @param labelNames
     */
    public MetricInfo(List<String> labelNames) {
        super();
        this.labelNames = labelNames;
    }

    /**
     * 
     * 
     */
    @JsonProperty("labelNames")
    public List<String> getLabelNames() {
        return labelNames;
    }

    /**
     * 
     * 
     */
    @JsonProperty("labelNames")
    public void setLabelNames(List<String> labelNames) {
        this.labelNames = labelNames;
    }

}
