package me.snowdrop.istio.mixer.adapter.stackdriver;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class AppCredentialsCredsBuilder extends AppCredentialsCredsFluentImpl<AppCredentialsCredsBuilder> implements VisitableBuilder<AppCredentialsCreds,AppCredentialsCredsBuilder>{

    AppCredentialsCredsFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public AppCredentialsCredsBuilder(){
            this(true);
    }
    public AppCredentialsCredsBuilder(Boolean validationEnabled){
            this(new AppCredentialsCreds(), validationEnabled);
    }
    public AppCredentialsCredsBuilder(AppCredentialsCredsFluent<?> fluent){
            this(fluent, true);
    }
    public AppCredentialsCredsBuilder(AppCredentialsCredsFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new AppCredentialsCreds(), validationEnabled);
    }
    public AppCredentialsCredsBuilder(AppCredentialsCredsFluent<?> fluent,AppCredentialsCreds instance){
            this(fluent, instance, true);
    }
    public AppCredentialsCredsBuilder(AppCredentialsCredsFluent<?> fluent,AppCredentialsCreds instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAppCredentials(instance.getAppCredentials()); 
            this.validationEnabled = validationEnabled; 
    }
    public AppCredentialsCredsBuilder(AppCredentialsCreds instance){
            this(instance,true);
    }
    public AppCredentialsCredsBuilder(AppCredentialsCreds instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAppCredentials(instance.getAppCredentials()); 
            this.validationEnabled = validationEnabled; 
    }
    public AppCredentialsCredsBuilder(Validator validator){
            this(new AppCredentialsCreds(), true);
    }
    public AppCredentialsCredsBuilder(AppCredentialsCredsFluent<?> fluent,AppCredentialsCreds instance,Validator validator){
            this.fluent = fluent; 
            fluent.withAppCredentials(instance.getAppCredentials()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public AppCredentialsCredsBuilder(AppCredentialsCreds instance,Validator validator){
            this.fluent = this; 
            this.withAppCredentials(instance.getAppCredentials()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public AppCredentialsCreds build(){
            AppCredentialsCreds buildable = new AppCredentialsCreds(fluent.isAppCredentials());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            AppCredentialsCredsBuilder that = (AppCredentialsCredsBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
