package me.snowdrop.istio.mixer.template.authorization;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import javax.validation.Valid;
import java.lang.Boolean;

public interface AuthorizationFluent<A extends AuthorizationFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public AuthorizationFluent.MetadataNested<A> withNewMetadata();
    public AuthorizationFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public AuthorizationFluent.MetadataNested<A> editMetadata();
    public AuthorizationFluent.MetadataNested<A> editOrNewMetadata();
    public AuthorizationFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public AuthorizationSpec getSpec();
    public AuthorizationSpec buildSpec();
    public A withSpec(AuthorizationSpec spec);
    public Boolean hasSpec();
    public AuthorizationFluent.SpecNested<A> withNewSpec();
    public AuthorizationFluent.SpecNested<A> withNewSpecLike(AuthorizationSpec item);
    public AuthorizationFluent.SpecNested<A> editSpec();
    public AuthorizationFluent.SpecNested<A> editOrNewSpec();
    public AuthorizationFluent.SpecNested<A> editOrNewSpecLike(AuthorizationSpec item);

    public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<AuthorizationFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SpecNested<N> extends Nested<N>,AuthorizationSpecFluent<AuthorizationFluent.SpecNested<N>>{

        
    public N and();    public N endSpec();
}


}
