package me.snowdrop.istio.mixer.template.authorization;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class AuthorizationSpecBuilder extends AuthorizationSpecFluentImpl<AuthorizationSpecBuilder> implements VisitableBuilder<AuthorizationSpec,AuthorizationSpecBuilder>{

    AuthorizationSpecFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public AuthorizationSpecBuilder(){
            this(true);
    }
    public AuthorizationSpecBuilder(Boolean validationEnabled){
            this(new AuthorizationSpec(), validationEnabled);
    }
    public AuthorizationSpecBuilder(AuthorizationSpecFluent<?> fluent){
            this(fluent, true);
    }
    public AuthorizationSpecBuilder(AuthorizationSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new AuthorizationSpec(), validationEnabled);
    }
    public AuthorizationSpecBuilder(AuthorizationSpecFluent<?> fluent,AuthorizationSpec instance){
            this(fluent, instance, true);
    }
    public AuthorizationSpecBuilder(AuthorizationSpecFluent<?> fluent,AuthorizationSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAction(instance.getAction()); 
            fluent.withName(instance.getName()); 
            fluent.withSubject(instance.getSubject()); 
            this.validationEnabled = validationEnabled; 
    }
    public AuthorizationSpecBuilder(AuthorizationSpec instance){
            this(instance,true);
    }
    public AuthorizationSpecBuilder(AuthorizationSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAction(instance.getAction()); 
            this.withName(instance.getName()); 
            this.withSubject(instance.getSubject()); 
            this.validationEnabled = validationEnabled; 
    }
    public AuthorizationSpecBuilder(Validator validator){
            this(new AuthorizationSpec(), true);
    }
    public AuthorizationSpecBuilder(AuthorizationSpecFluent<?> fluent,AuthorizationSpec instance,Validator validator){
            this.fluent = fluent; 
            fluent.withAction(instance.getAction()); 
            fluent.withName(instance.getName()); 
            fluent.withSubject(instance.getSubject()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public AuthorizationSpecBuilder(AuthorizationSpec instance,Validator validator){
            this.fluent = this; 
            this.withAction(instance.getAction()); 
            this.withName(instance.getName()); 
            this.withSubject(instance.getSubject()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public AuthorizationSpec build(){
            AuthorizationSpec buildable = new AuthorizationSpec(fluent.getAction(),fluent.getName(),fluent.getSubject());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            AuthorizationSpecBuilder that = (AuthorizationSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
