package me.snowdrop.istio.mixer.template.checknothing;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class CheckNothingListBuilder extends CheckNothingListFluentImpl<CheckNothingListBuilder> implements VisitableBuilder<CheckNothingList,CheckNothingListBuilder>{

    CheckNothingListFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public CheckNothingListBuilder(){
            this(true);
    }
    public CheckNothingListBuilder(Boolean validationEnabled){
            this(new CheckNothingList(), validationEnabled);
    }
    public CheckNothingListBuilder(CheckNothingListFluent<?> fluent){
            this(fluent, true);
    }
    public CheckNothingListBuilder(CheckNothingListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new CheckNothingList(), validationEnabled);
    }
    public CheckNothingListBuilder(CheckNothingListFluent<?> fluent,CheckNothingList instance){
            this(fluent, instance, true);
    }
    public CheckNothingListBuilder(CheckNothingListFluent<?> fluent,CheckNothingList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withItems(instance.getItems()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public CheckNothingListBuilder(CheckNothingList instance){
            this(instance,true);
    }
    public CheckNothingListBuilder(CheckNothingList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public CheckNothingListBuilder(Validator validator){
            this(new CheckNothingList(), true);
    }
    public CheckNothingListBuilder(CheckNothingListFluent<?> fluent,CheckNothingList instance,Validator validator){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withItems(instance.getItems()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public CheckNothingListBuilder(CheckNothingList instance,Validator validator){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public CheckNothingList build(){
            CheckNothingList buildable = new CheckNothingList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            CheckNothingListBuilder that = (CheckNothingListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
