package me.snowdrop.istio.mixer.template.checknothing;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.Deprecated;
import javax.validation.Valid;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;

public interface CheckNothingListFluent<A extends CheckNothingListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A addToItems(int index,CheckNothing item);
    public A setToItems(int index,CheckNothing item);
    public A addToItems(CheckNothing... items);
    public A addAllToItems(Collection<CheckNothing> items);
    public A removeFromItems(CheckNothing... items);
    public A removeAllFromItems(Collection<CheckNothing> items);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<CheckNothing> getItems();
    public List<CheckNothing> buildItems();
    public CheckNothing buildItem(int index);
    public CheckNothing buildFirstItem();
    public CheckNothing buildLastItem();
    public CheckNothing buildMatchingItem(Predicate<CheckNothingBuilder> predicate);
    public A withItems(List<CheckNothing> items);
    public A withItems(CheckNothing... items);
    public Boolean hasItems();
    public CheckNothingListFluent.ItemsNested<A> addNewItem();
    public CheckNothingListFluent.ItemsNested<A> addNewItemLike(CheckNothing item);
    public CheckNothingListFluent.ItemsNested<A> setNewItemLike(int index,CheckNothing item);
    public CheckNothingListFluent.ItemsNested<A> editItem(int index);
    public CheckNothingListFluent.ItemsNested<A> editFirstItem();
    public CheckNothingListFluent.ItemsNested<A> editLastItem();
    public CheckNothingListFluent.ItemsNested<A> editMatchingItem(Predicate<CheckNothingBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends Nested<N>,CheckNothingFluent<CheckNothingListFluent.ItemsNested<N>>{

        
    public N and();    public N endItem();
}


}
