package me.snowdrop.istio.mixer.template.edge;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.Deprecated;
import javax.validation.Valid;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;

public interface EdgeListFluent<A extends EdgeListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A addToItems(int index,Edge item);
    public A setToItems(int index,Edge item);
    public A addToItems(Edge... items);
    public A addAllToItems(Collection<Edge> items);
    public A removeFromItems(Edge... items);
    public A removeAllFromItems(Collection<Edge> items);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<Edge> getItems();
    public List<Edge> buildItems();
    public Edge buildItem(int index);
    public Edge buildFirstItem();
    public Edge buildLastItem();
    public Edge buildMatchingItem(Predicate<EdgeBuilder> predicate);
    public A withItems(List<Edge> items);
    public A withItems(Edge... items);
    public Boolean hasItems();
    public EdgeListFluent.ItemsNested<A> addNewItem();
    public EdgeListFluent.ItemsNested<A> addNewItemLike(Edge item);
    public EdgeListFluent.ItemsNested<A> setNewItemLike(int index,Edge item);
    public EdgeListFluent.ItemsNested<A> editItem(int index);
    public EdgeListFluent.ItemsNested<A> editFirstItem();
    public EdgeListFluent.ItemsNested<A> editLastItem();
    public EdgeListFluent.ItemsNested<A> editMatchingItem(Predicate<EdgeBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends Nested<N>,EdgeFluent<EdgeListFluent.ItemsNested<N>>{

        
    public N and();    public N endItem();
}


}
