
package me.snowdrop.istio.mixer.template.logentry;

import java.io.Serializable;
import java.util.Map;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import io.sundr.transform.annotations.VelocityTransformation;
import io.sundr.transform.annotations.VelocityTransformations;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.IstioSpec;
import me.snowdrop.istio.api.TimeStamp;
import me.snowdrop.istio.api.internal.IstioApiVersion;
import me.snowdrop.istio.api.internal.IstioKind;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "monitoredResourceDimensions",
    "monitoredResourceType",
    "name",
    "severity",
    "timestamp",
    "variables"
})
@IstioKind(name = "logentry", plural = "logentries")
@IstioApiVersion("config.istio.io/v1alpha2")
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = true, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
@VelocityTransformations({
    @VelocityTransformation("/istio-resource.vm"),
    @VelocityTransformation("/istio-resource-list.vm"),
    @VelocityTransformation(value = "/istio-manifest.vm", outputPath = "crd.properties", gather = true),
    @VelocityTransformation(value = "/istio-mappings-provider.vm", outputPath = "me/snowdrop/istio/api/model/IstioResourceMappingsProvider.java", gather = true)
})
public class LogEntrySpec implements Serializable, IstioSpec
{

    /**
     * 
     * 
     */
    @JsonProperty("monitoredResourceDimensions")
    @JsonPropertyDescription("")
    @Valid
    private Map<String, me.snowdrop.istio.api.cexl.TypedValue> monitoredResourceDimensions;
    /**
     * 
     * 
     */
    @JsonProperty("monitoredResourceType")
    @JsonPropertyDescription("")
    private java.lang.String monitoredResourceType;
    /**
     * 
     * 
     */
    @JsonProperty("name")
    @JsonPropertyDescription("")
    private java.lang.String name;
    /**
     * 
     * 
     */
    @JsonProperty("severity")
    @JsonPropertyDescription("")
    private java.lang.String severity;
    /**
     * 
     * 
     */
    @JsonProperty("timestamp")
    @JsonPropertyDescription("")
    @Valid
    private TimeStamp timestamp;
    /**
     * 
     * 
     */
    @JsonProperty("variables")
    @JsonPropertyDescription("")
    @Valid
    private Map<String, me.snowdrop.istio.api.cexl.TypedValue> variables;
    private final static long serialVersionUID = -6101788533143886692L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public LogEntrySpec() {
    }

    /**
     * 
     * @param severity
     * @param variables
     * @param monitoredResourceType
     * @param name
     * @param monitoredResourceDimensions
     * @param timestamp
     */
    public LogEntrySpec(Map<String, me.snowdrop.istio.api.cexl.TypedValue> monitoredResourceDimensions, java.lang.String monitoredResourceType, java.lang.String name, java.lang.String severity, TimeStamp timestamp, Map<String, me.snowdrop.istio.api.cexl.TypedValue> variables) {
        super();
        this.monitoredResourceDimensions = monitoredResourceDimensions;
        this.monitoredResourceType = monitoredResourceType;
        this.name = name;
        this.severity = severity;
        this.timestamp = timestamp;
        this.variables = variables;
    }

    /**
     * 
     * 
     */
    @JsonProperty("monitoredResourceDimensions")
    public Map<String, me.snowdrop.istio.api.cexl.TypedValue> getMonitoredResourceDimensions() {
        return monitoredResourceDimensions;
    }

    /**
     * 
     * 
     */
    @JsonProperty("monitoredResourceDimensions")
    public void setMonitoredResourceDimensions(Map<String, me.snowdrop.istio.api.cexl.TypedValue> monitoredResourceDimensions) {
        this.monitoredResourceDimensions = monitoredResourceDimensions;
    }

    /**
     * 
     * 
     */
    @JsonProperty("monitoredResourceType")
    public java.lang.String getMonitoredResourceType() {
        return monitoredResourceType;
    }

    /**
     * 
     * 
     */
    @JsonProperty("monitoredResourceType")
    public void setMonitoredResourceType(java.lang.String monitoredResourceType) {
        this.monitoredResourceType = monitoredResourceType;
    }

    /**
     * 
     * 
     */
    @JsonProperty("name")
    public java.lang.String getName() {
        return name;
    }

    /**
     * 
     * 
     */
    @JsonProperty("name")
    public void setName(java.lang.String name) {
        this.name = name;
    }

    /**
     * 
     * 
     */
    @JsonProperty("severity")
    public java.lang.String getSeverity() {
        return severity;
    }

    /**
     * 
     * 
     */
    @JsonProperty("severity")
    public void setSeverity(java.lang.String severity) {
        this.severity = severity;
    }

    /**
     * 
     * 
     */
    @JsonProperty("timestamp")
    public TimeStamp getTimestamp() {
        return timestamp;
    }

    /**
     * 
     * 
     */
    @JsonProperty("timestamp")
    public void setTimestamp(TimeStamp timestamp) {
        this.timestamp = timestamp;
    }

    /**
     * 
     * 
     */
    @JsonProperty("variables")
    public Map<String, me.snowdrop.istio.api.cexl.TypedValue> getVariables() {
        return variables;
    }

    /**
     * 
     * 
     */
    @JsonProperty("variables")
    public void setVariables(Map<String, me.snowdrop.istio.api.cexl.TypedValue> variables) {
        this.variables = variables;
    }

}
