package me.snowdrop.istio.mixer.template.metric;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class MetricListBuilder extends MetricListFluentImpl<MetricListBuilder> implements VisitableBuilder<MetricList,MetricListBuilder>{

    MetricListFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public MetricListBuilder(){
            this(true);
    }
    public MetricListBuilder(Boolean validationEnabled){
            this(new MetricList(), validationEnabled);
    }
    public MetricListBuilder(MetricListFluent<?> fluent){
            this(fluent, true);
    }
    public MetricListBuilder(MetricListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new MetricList(), validationEnabled);
    }
    public MetricListBuilder(MetricListFluent<?> fluent,MetricList instance){
            this(fluent, instance, true);
    }
    public MetricListBuilder(MetricListFluent<?> fluent,MetricList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withItems(instance.getItems()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public MetricListBuilder(MetricList instance){
            this(instance,true);
    }
    public MetricListBuilder(MetricList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public MetricListBuilder(Validator validator){
            this(new MetricList(), true);
    }
    public MetricListBuilder(MetricListFluent<?> fluent,MetricList instance,Validator validator){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withItems(instance.getItems()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public MetricListBuilder(MetricList instance,Validator validator){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public MetricList build(){
            MetricList buildable = new MetricList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            MetricListBuilder that = (MetricListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
