package me.snowdrop.istio.mixer.template.metric;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import com.fasterxml.jackson.databind.JsonSerializer;
import java.lang.String;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.util.LinkedHashMap;
import me.snowdrop.istio.api.cexl.TypedValueFluent;
import me.snowdrop.istio.api.cexl.TypedValueBuilder;
import java.lang.Deprecated;
import javax.validation.Valid;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.lang.Boolean;
import java.lang.Override;
import java.util.Map;
import com.fasterxml.jackson.core.JsonParser;
import me.snowdrop.istio.api.cexl.TypedValue;

public interface MetricSpecFluent<A extends MetricSpecFluent<A>> extends Fluent<A>{


    public A addToDimensions(String key,TypedValue value);
    public A addToDimensions(Map<String,TypedValue> map);
    public A removeFromDimensions(String key);
    public A removeFromDimensions(Map<String,TypedValue> map);
    public Map<String,TypedValue> getDimensions();
    public A withDimensions(Map<String,TypedValue> dimensions);
    public Boolean hasDimensions();
    public A addToMonitoredResourceDimensions(String key,TypedValue value);
    public A addToMonitoredResourceDimensions(Map<String,TypedValue> map);
    public A removeFromMonitoredResourceDimensions(String key);
    public A removeFromMonitoredResourceDimensions(Map<String,TypedValue> map);
    public Map<String,TypedValue> getMonitoredResourceDimensions();
    public A withMonitoredResourceDimensions(Map<String,TypedValue> monitoredResourceDimensions);
    public Boolean hasMonitoredResourceDimensions();
    public String getMonitoredResourceType();
    public A withMonitoredResourceType(String monitoredResourceType);
    public Boolean hasMonitoredResourceType();
    public String getName();
    public A withName(String name);
    public Boolean hasName();
    
/**
 * This method has been deprecated, please use method buildValue instead.
 * @return The buildable object.
 */
@Deprecated public TypedValue getValue();
    public TypedValue buildValue();
    public A withValue(TypedValue value);
    public Boolean hasValue();
    public MetricSpecFluent.ValueNested<A> withNewValue();
    public MetricSpecFluent.ValueNested<A> withNewValueLike(TypedValue item);
    public MetricSpecFluent.ValueNested<A> editValue();
    public MetricSpecFluent.ValueNested<A> editOrNewValue();
    public MetricSpecFluent.ValueNested<A> editOrNewValueLike(TypedValue item);

    public interface ValueNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,TypedValueFluent<MetricSpecFluent.ValueNested<N>>{

        
    public N and();    public N endValue();
}


}
