package me.snowdrop.istio.mixer.template.tracespan;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.Deprecated;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class TraceSpanListFluentImpl<A extends TraceSpanListFluent<A>> extends BaseFluent<A> implements TraceSpanListFluent<A>{

    private String apiVersion;
    private List<TraceSpanBuilder> items;
    private String kind;
    private ListMeta metadata;

    public TraceSpanListFluentImpl(){
    }
    public TraceSpanListFluentImpl(TraceSpanList instance){
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion(){
            return this.apiVersion != null;
    }

    public A addToItems(int index,TraceSpan item){
            if (this.items == null) {this.items = new ArrayList<TraceSpanBuilder>();}
            TraceSpanBuilder builder = new TraceSpanBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
    }

    public A setToItems(int index,TraceSpan item){
            if (this.items == null) {this.items = new ArrayList<TraceSpanBuilder>();}
            TraceSpanBuilder builder = new TraceSpanBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
             return (A)this;
    }

    public A addToItems(TraceSpan... items){
            if (this.items == null) {this.items = new ArrayList<TraceSpanBuilder>();}
            for (TraceSpan item : items) {TraceSpanBuilder builder = new TraceSpanBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A addAllToItems(Collection<TraceSpan> items){
            if (this.items == null) {this.items = new ArrayList<TraceSpanBuilder>();}
            for (TraceSpan item : items) {TraceSpanBuilder builder = new TraceSpanBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromItems(TraceSpan... items){
            for (TraceSpan item : items) {TraceSpanBuilder builder = new TraceSpanBuilder(item);_visitables.remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
    }

    public A removeAllFromItems(Collection<TraceSpan> items){
            for (TraceSpan item : items) {TraceSpanBuilder builder = new TraceSpanBuilder(item);_visitables.remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<TraceSpan> getItems(){
            return build(items);
    }

    public List<TraceSpan> buildItems(){
            return build(items);
    }

    public TraceSpan buildItem(int index){
            return this.items.get(index).build();
    }

    public TraceSpan buildFirstItem(){
            return this.items.get(0).build();
    }

    public TraceSpan buildLastItem(){
            return this.items.get(items.size() - 1).build();
    }

    public TraceSpan buildMatchingItem(Predicate<TraceSpanBuilder> predicate){
            for (TraceSpanBuilder item: items) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public A withItems(List<TraceSpan> items){
            if (this.items != null) { _visitables.removeAll(this.items);}
            if (items != null) {this.items = new ArrayList<TraceSpanBuilder>(); for (TraceSpan item : items){this.addToItems(item);}} else { this.items = null;} return (A) this;
    }

    public A withItems(TraceSpan... items){
            if (this.items != null) {this.items.clear();}
            if (items != null) {for (TraceSpan item :items){ this.addToItems(item);}} return (A) this;
    }

    public Boolean hasItems(){
            return items != null && !items.isEmpty();
    }

    public TraceSpanListFluent.ItemsNested<A> addNewItem(){
            return new ItemsNestedImpl();
    }

    public TraceSpanListFluent.ItemsNested<A> addNewItemLike(TraceSpan item){
            return new ItemsNestedImpl(-1, item);
    }

    public TraceSpanListFluent.ItemsNested<A> setNewItemLike(int index,TraceSpan item){
            return new ItemsNestedImpl(index, item);
    }

    public TraceSpanListFluent.ItemsNested<A> editItem(int index){
            if (items.size() <= index) throw new RuntimeException("Can't edit items. Index exceeds size.");
            return setNewItemLike(index, buildItem(index));
    }

    public TraceSpanListFluent.ItemsNested<A> editFirstItem(){
            if (items.size() == 0) throw new RuntimeException("Can't edit first items. The list is empty.");
            return setNewItemLike(0, buildItem(0));
    }

    public TraceSpanListFluent.ItemsNested<A> editLastItem(){
            int index = items.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last items. The list is empty.");
            return setNewItemLike(index, buildItem(index));
    }

    public TraceSpanListFluent.ItemsNested<A> editMatchingItem(Predicate<TraceSpanBuilder> predicate){
            int index = -1;
            for (int i=0;i<items.size();i++) { 
            if (predicate.apply(items.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching items. No match found.");
            return setNewItemLike(index, buildItem(index));
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public Boolean hasKind(){
            return this.kind != null;
    }

    public ListMeta getMetadata(){
            return this.metadata;
    }

    public A withMetadata(ListMeta metadata){
            this.metadata=metadata; return (A) this;
    }

    public Boolean hasMetadata(){
            return this.metadata != null;
    }

    public A withNewMetadata(String _continue,String resourceVersion,String selfLink){
            return (A)withMetadata(new ListMeta(_continue, resourceVersion, selfLink));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            TraceSpanListFluentImpl that = (TraceSpanListFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (items != null ? !items.equals(that.items) :that.items != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
            return true;
    }


    public class ItemsNestedImpl<N> extends TraceSpanFluentImpl<TraceSpanListFluent.ItemsNested<N>> implements TraceSpanListFluent.ItemsNested<N>,Nested<N>{

            private final TraceSpanBuilder builder;
        private final int index;
    
            ItemsNestedImpl(int index,TraceSpan item){
                    this.index = index;
                    this.builder = new TraceSpanBuilder(this, item);
            }
            ItemsNestedImpl(){
                    this.index = -1;
                    this.builder = new TraceSpanBuilder(this);
            }
    
    public N and(){
            return (N) TraceSpanListFluentImpl.this.setToItems(index, builder.build());
    }
    public N endItem(){
            return and();
    }

}


}
