package me.snowdrop.istio.mixer.template.tracespan;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import me.snowdrop.istio.api.TimeStampBuilder;
import com.fasterxml.jackson.databind.JsonSerializer;
import java.lang.String;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import me.snowdrop.istio.api.TimeStampFluentImpl;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.lang.Boolean;
import java.lang.Override;
import com.fasterxml.jackson.core.JsonParser;
import me.snowdrop.istio.api.cexl.TypedValue;
import me.snowdrop.istio.api.TimeStamp;
import java.lang.Integer;
import javax.validation.Valid;
import java.lang.Long;
import java.lang.Object;
import java.util.Map;

public class TraceSpanSpecFluentImpl<A extends TraceSpanSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements TraceSpanSpecFluent<A>{

    private Boolean clientSpan;
    private TimeStampBuilder endTime;
    private Long httpStatusCode;
    private String name;
    private String parentSpanId;
    private Boolean rewriteClientSpanId;
    private String spanId;
    private String spanName;
    private Map<String,TypedValue> spanTags;
    private TimeStampBuilder startTime;
    private String traceId;

    public TraceSpanSpecFluentImpl(){
    }
    public TraceSpanSpecFluentImpl(TraceSpanSpec instance){
            this.withClientSpan(instance.getClientSpan()); 
            this.withEndTime(instance.getEndTime()); 
            this.withHttpStatusCode(instance.getHttpStatusCode()); 
            this.withName(instance.getName()); 
            this.withParentSpanId(instance.getParentSpanId()); 
            this.withRewriteClientSpanId(instance.getRewriteClientSpanId()); 
            this.withSpanId(instance.getSpanId()); 
            this.withSpanName(instance.getSpanName()); 
            this.withSpanTags(instance.getSpanTags()); 
            this.withStartTime(instance.getStartTime()); 
            this.withTraceId(instance.getTraceId()); 
    }

    public Boolean isClientSpan(){
            return this.clientSpan;
    }

    public A withClientSpan(Boolean clientSpan){
            this.clientSpan=clientSpan; return (A) this;
    }

    public Boolean hasClientSpan(){
            return this.clientSpan != null;
    }

    public A withNewClientSpan(String arg1){
            return (A)withClientSpan(new Boolean(arg1));
    }

    public A withNewClientSpan(boolean arg1){
            return (A)withClientSpan(new Boolean(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildEndTime instead.
 * @return The buildable object.
 */
@Deprecated public TimeStamp getEndTime(){
            return this.endTime!=null?this.endTime.build():null;
    }

    public TimeStamp buildEndTime(){
            return this.endTime!=null?this.endTime.build():null;
    }

    public A withEndTime(TimeStamp endTime){
            _visitables.remove(this.endTime);
            if (endTime!=null){ this.endTime= new TimeStampBuilder(endTime); _visitables.add(this.endTime);} return (A) this;
    }

    public Boolean hasEndTime(){
            return this.endTime != null;
    }

    public A withNewEndTime(Integer nanos,Long seconds){
            return (A)withEndTime(new TimeStamp(nanos, seconds));
    }

    public TraceSpanSpecFluent.EndTimeNested<A> withNewEndTime(){
            return new EndTimeNestedImpl();
    }

    public TraceSpanSpecFluent.EndTimeNested<A> withNewEndTimeLike(TimeStamp item){
            return new EndTimeNestedImpl(item);
    }

    public TraceSpanSpecFluent.EndTimeNested<A> editEndTime(){
            return withNewEndTimeLike(getEndTime());
    }

    public TraceSpanSpecFluent.EndTimeNested<A> editOrNewEndTime(){
            return withNewEndTimeLike(getEndTime() != null ? getEndTime(): new TimeStampBuilder().build());
    }

    public TraceSpanSpecFluent.EndTimeNested<A> editOrNewEndTimeLike(TimeStamp item){
            return withNewEndTimeLike(getEndTime() != null ? getEndTime(): item);
    }

    public Long getHttpStatusCode(){
            return this.httpStatusCode;
    }

    public A withHttpStatusCode(Long httpStatusCode){
            this.httpStatusCode=httpStatusCode; return (A) this;
    }

    public Boolean hasHttpStatusCode(){
            return this.httpStatusCode != null;
    }

    public A withNewHttpStatusCode(String arg1){
            return (A)withHttpStatusCode(new Long(arg1));
    }

    public A withNewHttpStatusCode(long arg1){
            return (A)withHttpStatusCode(new Long(arg1));
    }

    public String getName(){
            return this.name;
    }

    public A withName(String name){
            this.name=name; return (A) this;
    }

    public Boolean hasName(){
            return this.name != null;
    }

    public String getParentSpanId(){
            return this.parentSpanId;
    }

    public A withParentSpanId(String parentSpanId){
            this.parentSpanId=parentSpanId; return (A) this;
    }

    public Boolean hasParentSpanId(){
            return this.parentSpanId != null;
    }

    public Boolean isRewriteClientSpanId(){
            return this.rewriteClientSpanId;
    }

    public A withRewriteClientSpanId(Boolean rewriteClientSpanId){
            this.rewriteClientSpanId=rewriteClientSpanId; return (A) this;
    }

    public Boolean hasRewriteClientSpanId(){
            return this.rewriteClientSpanId != null;
    }

    public A withNewRewriteClientSpanId(String arg1){
            return (A)withRewriteClientSpanId(new Boolean(arg1));
    }

    public A withNewRewriteClientSpanId(boolean arg1){
            return (A)withRewriteClientSpanId(new Boolean(arg1));
    }

    public String getSpanId(){
            return this.spanId;
    }

    public A withSpanId(String spanId){
            this.spanId=spanId; return (A) this;
    }

    public Boolean hasSpanId(){
            return this.spanId != null;
    }

    public String getSpanName(){
            return this.spanName;
    }

    public A withSpanName(String spanName){
            this.spanName=spanName; return (A) this;
    }

    public Boolean hasSpanName(){
            return this.spanName != null;
    }

    public A addToSpanTags(String key,TypedValue value){
            if(this.spanTags == null && key != null && value != null) { this.spanTags = new LinkedHashMap<String,TypedValue>(); }
            if(key != null && value != null) {this.spanTags.put(key, value);} return (A)this;
    }

    public A addToSpanTags(Map<String,TypedValue> map){
            if(this.spanTags == null && map != null) { this.spanTags = new LinkedHashMap<String,TypedValue>(); }
            if(map != null) { this.spanTags.putAll(map);} return (A)this;
    }

    public A removeFromSpanTags(String key){
            if(this.spanTags == null) { return (A) this; }
            if(key != null && this.spanTags != null) {this.spanTags.remove(key);} return (A)this;
    }

    public A removeFromSpanTags(Map<String,TypedValue> map){
            if(this.spanTags == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.spanTags != null){this.spanTags.remove(key);}}} return (A)this;
    }

    public Map<String,TypedValue> getSpanTags(){
            return this.spanTags;
    }

    public A withSpanTags(Map<String,TypedValue> spanTags){
            if (spanTags == null) { this.spanTags =  null;} else {this.spanTags = new LinkedHashMap<String,TypedValue>(spanTags);} return (A) this;
    }

    public Boolean hasSpanTags(){
            return this.spanTags != null;
    }

    
/**
 * This method has been deprecated, please use method buildStartTime instead.
 * @return The buildable object.
 */
@Deprecated public TimeStamp getStartTime(){
            return this.startTime!=null?this.startTime.build():null;
    }

    public TimeStamp buildStartTime(){
            return this.startTime!=null?this.startTime.build():null;
    }

    public A withStartTime(TimeStamp startTime){
            _visitables.remove(this.startTime);
            if (startTime!=null){ this.startTime= new TimeStampBuilder(startTime); _visitables.add(this.startTime);} return (A) this;
    }

    public Boolean hasStartTime(){
            return this.startTime != null;
    }

    public A withNewStartTime(Integer nanos,Long seconds){
            return (A)withStartTime(new TimeStamp(nanos, seconds));
    }

    public TraceSpanSpecFluent.StartTimeNested<A> withNewStartTime(){
            return new StartTimeNestedImpl();
    }

    public TraceSpanSpecFluent.StartTimeNested<A> withNewStartTimeLike(TimeStamp item){
            return new StartTimeNestedImpl(item);
    }

    public TraceSpanSpecFluent.StartTimeNested<A> editStartTime(){
            return withNewStartTimeLike(getStartTime());
    }

    public TraceSpanSpecFluent.StartTimeNested<A> editOrNewStartTime(){
            return withNewStartTimeLike(getStartTime() != null ? getStartTime(): new TimeStampBuilder().build());
    }

    public TraceSpanSpecFluent.StartTimeNested<A> editOrNewStartTimeLike(TimeStamp item){
            return withNewStartTimeLike(getStartTime() != null ? getStartTime(): item);
    }

    public String getTraceId(){
            return this.traceId;
    }

    public A withTraceId(String traceId){
            this.traceId=traceId; return (A) this;
    }

    public Boolean hasTraceId(){
            return this.traceId != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            TraceSpanSpecFluentImpl that = (TraceSpanSpecFluentImpl) o;
            if (clientSpan != null ? !clientSpan.equals(that.clientSpan) :that.clientSpan != null) return false;
            if (endTime != null ? !endTime.equals(that.endTime) :that.endTime != null) return false;
            if (httpStatusCode != null ? !httpStatusCode.equals(that.httpStatusCode) :that.httpStatusCode != null) return false;
            if (name != null ? !name.equals(that.name) :that.name != null) return false;
            if (parentSpanId != null ? !parentSpanId.equals(that.parentSpanId) :that.parentSpanId != null) return false;
            if (rewriteClientSpanId != null ? !rewriteClientSpanId.equals(that.rewriteClientSpanId) :that.rewriteClientSpanId != null) return false;
            if (spanId != null ? !spanId.equals(that.spanId) :that.spanId != null) return false;
            if (spanName != null ? !spanName.equals(that.spanName) :that.spanName != null) return false;
            if (spanTags != null ? !spanTags.equals(that.spanTags) :that.spanTags != null) return false;
            if (startTime != null ? !startTime.equals(that.startTime) :that.startTime != null) return false;
            if (traceId != null ? !traceId.equals(that.traceId) :that.traceId != null) return false;
            return true;
    }


    public class EndTimeNestedImpl<N> extends TimeStampFluentImpl<TraceSpanSpecFluent.EndTimeNested<N>> implements TraceSpanSpecFluent.EndTimeNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final TimeStampBuilder builder;
    
            EndTimeNestedImpl(TimeStamp item){
                    this.builder = new TimeStampBuilder(this, item);
            }
            EndTimeNestedImpl(){
                    this.builder = new TimeStampBuilder(this);
            }
    
    public N and(){
            return (N) TraceSpanSpecFluentImpl.this.withEndTime(builder.build());
    }
    public N endEndTime(){
            return and();
    }

}
    public class StartTimeNestedImpl<N> extends TimeStampFluentImpl<TraceSpanSpecFluent.StartTimeNested<N>> implements TraceSpanSpecFluent.StartTimeNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final TimeStampBuilder builder;
    
            StartTimeNestedImpl(TimeStamp item){
                    this.builder = new TimeStampBuilder(this, item);
            }
            StartTimeNestedImpl(){
                    this.builder = new TimeStampBuilder(this);
            }
    
    public N and(){
            return (N) TraceSpanSpecFluentImpl.this.withStartTime(builder.build());
    }
    public N endStartTime(){
            return and();
    }

}


}
