/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.api.authentication.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.snowdrop.istio.api.authentication.v1alpha1.PortSelector;
import me.snowdrop.istio.api.authentication.v1alpha1.PortSelectorBuilder;
import me.snowdrop.istio.api.authentication.v1alpha1.PortSelectorFluentImpl;
import me.snowdrop.istio.api.authentication.v1alpha1.TargetSelector;
import me.snowdrop.istio.api.authentication.v1alpha1.TargetSelectorFluent;

public class TargetSelectorFluentImpl<A extends TargetSelectorFluent<A>>
extends BaseFluent<A>
implements TargetSelectorFluent<A> {
    private String name;
    private List<PortSelectorBuilder> ports;

    public TargetSelectorFluentImpl() {
    }

    public TargetSelectorFluentImpl(TargetSelector instance) {
        this.withName(instance.getName());
        this.withPorts(instance.getPorts());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    public A addToPorts(int index, PortSelector item) {
        if (this.ports == null) {
            this.ports = new ArrayList<PortSelectorBuilder>();
        }
        PortSelectorBuilder builder = new PortSelectorBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.ports.add(index >= 0 ? index : this.ports.size(), builder);
        return (A)this;
    }

    @Override
    public A setToPorts(int index, PortSelector item) {
        if (this.ports == null) {
            this.ports = new ArrayList<PortSelectorBuilder>();
        }
        PortSelectorBuilder builder = new PortSelectorBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.ports.size()) {
            this.ports.add(builder);
        } else {
            this.ports.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToPorts(PortSelector ... items) {
        if (this.ports == null) {
            this.ports = new ArrayList<PortSelectorBuilder>();
        }
        for (PortSelector item : items) {
            PortSelectorBuilder builder = new PortSelectorBuilder(item);
            this._visitables.add(builder);
            this.ports.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToPorts(Collection<PortSelector> items) {
        if (this.ports == null) {
            this.ports = new ArrayList<PortSelectorBuilder>();
        }
        for (PortSelector item : items) {
            PortSelectorBuilder builder = new PortSelectorBuilder(item);
            this._visitables.add(builder);
            this.ports.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromPorts(PortSelector ... items) {
        for (PortSelector item : items) {
            PortSelectorBuilder builder = new PortSelectorBuilder(item);
            this._visitables.remove(builder);
            if (this.ports == null) continue;
            this.ports.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromPorts(Collection<PortSelector> items) {
        for (PortSelector item : items) {
            PortSelectorBuilder builder = new PortSelectorBuilder(item);
            this._visitables.remove(builder);
            if (this.ports == null) continue;
            this.ports.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<PortSelector> getPorts() {
        return TargetSelectorFluentImpl.build(this.ports);
    }

    @Override
    public List<PortSelector> buildPorts() {
        return TargetSelectorFluentImpl.build(this.ports);
    }

    @Override
    public PortSelector buildPort(int index) {
        return this.ports.get(index).build();
    }

    @Override
    public PortSelector buildFirstPort() {
        return this.ports.get(0).build();
    }

    @Override
    public PortSelector buildLastPort() {
        return this.ports.get(this.ports.size() - 1).build();
    }

    @Override
    public PortSelector buildMatchingPort(Predicate<PortSelectorBuilder> predicate) {
        for (PortSelectorBuilder item : this.ports) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withPorts(List<PortSelector> ports) {
        if (this.ports != null) {
            this._visitables.removeAll(this.ports);
        }
        if (ports != null) {
            this.ports = new ArrayList<PortSelectorBuilder>();
            for (PortSelector item : ports) {
                this.addToPorts(item);
            }
        } else {
            this.ports = null;
        }
        return (A)this;
    }

    @Override
    public A withPorts(PortSelector ... ports) {
        if (this.ports != null) {
            this.ports.clear();
        }
        if (ports != null) {
            for (PortSelector item : ports) {
                this.addToPorts(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasPorts() {
        return this.ports != null && !this.ports.isEmpty();
    }

    @Override
    public TargetSelectorFluent.PortsNested<A> addNewPort() {
        return new PortsNestedImpl();
    }

    @Override
    public TargetSelectorFluent.PortsNested<A> addNewPortLike(PortSelector item) {
        return new PortsNestedImpl(-1, item);
    }

    @Override
    public TargetSelectorFluent.PortsNested<A> setNewPortLike(int index, PortSelector item) {
        return new PortsNestedImpl(index, item);
    }

    @Override
    public TargetSelectorFluent.PortsNested<A> editPort(int index) {
        if (this.ports.size() <= index) {
            throw new RuntimeException("Can't edit ports. Index exceeds size.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    @Override
    public TargetSelectorFluent.PortsNested<A> editFirstPort() {
        if (this.ports.size() == 0) {
            throw new RuntimeException("Can't edit first ports. The list is empty.");
        }
        return this.setNewPortLike(0, this.buildPort(0));
    }

    @Override
    public TargetSelectorFluent.PortsNested<A> editLastPort() {
        int index = this.ports.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last ports. The list is empty.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    @Override
    public TargetSelectorFluent.PortsNested<A> editMatchingPort(Predicate<PortSelectorBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.ports.size(); ++i) {
            if (!predicate.apply((Object)this.ports.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching ports. No match found.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TargetSelectorFluentImpl that = (TargetSelectorFluentImpl)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return !(this.ports != null ? !this.ports.equals(that.ports) : that.ports != null);
    }

    public class PortsNestedImpl<N>
    extends PortSelectorFluentImpl<TargetSelectorFluent.PortsNested<N>>
    implements TargetSelectorFluent.PortsNested<N>,
    Nested<N> {
        private final PortSelectorBuilder builder;
        private final int index;

        PortsNestedImpl(int index, PortSelector item) {
            this.index = index;
            this.builder = new PortSelectorBuilder(this, item);
        }

        PortsNestedImpl() {
            this.index = -1;
            this.builder = new PortSelectorBuilder(this);
        }

        @Override
        public N and() {
            return (N)TargetSelectorFluentImpl.this.setToPorts(this.index, this.builder.build());
        }

        @Override
        public N endPort() {
            return this.and();
        }
    }
}

