/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.mixer.adapter.servicecontrol;

import io.fabric8.kubernetes.api.builder.ValidationUtils;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import javax.validation.Validator;
import me.snowdrop.istio.mixer.adapter.servicecontrol.GcpServiceSetting;
import me.snowdrop.istio.mixer.adapter.servicecontrol.GcpServiceSettingFluent;
import me.snowdrop.istio.mixer.adapter.servicecontrol.GcpServiceSettingFluentImpl;

public class GcpServiceSettingBuilder
extends GcpServiceSettingFluentImpl<GcpServiceSettingBuilder>
implements VisitableBuilder<GcpServiceSetting, GcpServiceSettingBuilder> {
    GcpServiceSettingFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public GcpServiceSettingBuilder() {
        this(true);
    }

    public GcpServiceSettingBuilder(Boolean validationEnabled) {
        this(new GcpServiceSetting(), validationEnabled);
    }

    public GcpServiceSettingBuilder(GcpServiceSettingFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public GcpServiceSettingBuilder(GcpServiceSettingFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new GcpServiceSetting(), validationEnabled);
    }

    public GcpServiceSettingBuilder(GcpServiceSettingFluent<?> fluent, GcpServiceSetting instance) {
        this(fluent, instance, true);
    }

    public GcpServiceSettingBuilder(GcpServiceSettingFluent<?> fluent, GcpServiceSetting instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withGoogleServiceName(instance.getGoogleServiceName());
        fluent.withMeshServiceName(instance.getMeshServiceName());
        fluent.withQuotas(instance.getQuotas());
        this.validationEnabled = validationEnabled;
    }

    public GcpServiceSettingBuilder(GcpServiceSetting instance) {
        this(instance, (Boolean)true);
    }

    public GcpServiceSettingBuilder(GcpServiceSetting instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withGoogleServiceName(instance.getGoogleServiceName());
        this.withMeshServiceName(instance.getMeshServiceName());
        this.withQuotas(instance.getQuotas());
        this.validationEnabled = validationEnabled;
    }

    public GcpServiceSettingBuilder(Validator validator) {
        this(new GcpServiceSetting(), (Boolean)true);
    }

    public GcpServiceSettingBuilder(GcpServiceSettingFluent<?> fluent, GcpServiceSetting instance, Validator validator) {
        this.fluent = fluent;
        fluent.withGoogleServiceName(instance.getGoogleServiceName());
        fluent.withMeshServiceName(instance.getMeshServiceName());
        fluent.withQuotas(instance.getQuotas());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public GcpServiceSettingBuilder(GcpServiceSetting instance, Validator validator) {
        this.fluent = this;
        this.withGoogleServiceName(instance.getGoogleServiceName());
        this.withMeshServiceName(instance.getMeshServiceName());
        this.withQuotas(instance.getQuotas());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public GcpServiceSetting build() {
        GcpServiceSetting buildable = new GcpServiceSetting(this.fluent.getGoogleServiceName(), this.fluent.getMeshServiceName(), this.fluent.getQuotas());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate((Object)buildable);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GcpServiceSettingBuilder that = (GcpServiceSettingBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

