/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.mixer.adapter.stackdriver;

import io.fabric8.kubernetes.api.builder.ValidationUtils;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import javax.validation.Validator;
import me.snowdrop.istio.mixer.adapter.stackdriver.Stackdriver;
import me.snowdrop.istio.mixer.adapter.stackdriver.StackdriverFluent;
import me.snowdrop.istio.mixer.adapter.stackdriver.StackdriverFluentImpl;

public class StackdriverBuilder
extends StackdriverFluentImpl<StackdriverBuilder>
implements VisitableBuilder<Stackdriver, StackdriverBuilder> {
    StackdriverFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public StackdriverBuilder() {
        this(true);
    }

    public StackdriverBuilder(Boolean validationEnabled) {
        this(new Stackdriver(), validationEnabled);
    }

    public StackdriverBuilder(StackdriverFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public StackdriverBuilder(StackdriverFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Stackdriver(), validationEnabled);
    }

    public StackdriverBuilder(StackdriverFluent<?> fluent, Stackdriver instance) {
        this(fluent, instance, true);
    }

    public StackdriverBuilder(StackdriverFluent<?> fluent, Stackdriver instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        this.validationEnabled = validationEnabled;
    }

    public StackdriverBuilder(Stackdriver instance) {
        this(instance, (Boolean)true);
    }

    public StackdriverBuilder(Stackdriver instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.validationEnabled = validationEnabled;
    }

    public StackdriverBuilder(Validator validator) {
        this(new Stackdriver(), (Boolean)true);
    }

    public StackdriverBuilder(StackdriverFluent<?> fluent, Stackdriver instance, Validator validator) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public StackdriverBuilder(Stackdriver instance, Validator validator) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public Stackdriver build() {
        Stackdriver buildable = new Stackdriver(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getSpec());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate((Object)buildable);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        StackdriverBuilder that = (StackdriverBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

