/*
 * Decompiled with CFR 0.152.
 */
package me.tongfei.progressbar;

import me.tongfei.progressbar.ProgressBarStyle;

public class ProgressBarStyleBuilder {
    private static final String ESC_CODE = "\u001b[";
    private ProgressBarStyle style = new ProgressBarStyle("\r", "[", "", "]", '=', ' ', ">", ' ');
    private byte colorCode = 0;

    public ProgressBarStyleBuilder refreshPrompt(String refreshPrompt) {
        this.style.refreshPrompt = refreshPrompt;
        return this;
    }

    public ProgressBarStyleBuilder leftBracket(String leftBracket) {
        this.style.leftBracket = leftBracket;
        return this;
    }

    public ProgressBarStyleBuilder delimitingSequence(String delimitingSequence) {
        this.style.delimitingSequence = delimitingSequence;
        return this;
    }

    public ProgressBarStyleBuilder rightBracket(String rightBracket) {
        this.style.rightBracket = rightBracket;
        return this;
    }

    public ProgressBarStyleBuilder block(char block) {
        this.style.block = block;
        return this;
    }

    public ProgressBarStyleBuilder space(char space) {
        this.style.space = space;
        return this;
    }

    public ProgressBarStyleBuilder fractionSymbols(String fractionSymbols) {
        this.style.fractionSymbols = fractionSymbols;
        return this;
    }

    public ProgressBarStyleBuilder rightSideFractionSymbol(char rightSideFractionSymbol) {
        this.style.rightSideFractionSymbol = rightSideFractionSymbol;
        return this;
    }

    public ProgressBarStyleBuilder colorCode(byte code) {
        this.colorCode = code;
        return this;
    }

    public ProgressBarStyle build() {
        boolean colorDefined;
        boolean bl = colorDefined = this.colorCode != 0;
        if (colorDefined && this.style.leftBracket.contains(ESC_CODE)) {
            throw new IllegalArgumentException("The color code is overridden with left bracket escape code. Please, remove the escape sequence from the left bracket or do not use color code.");
        }
        String prefix = colorDefined ? ESC_CODE + this.colorCode + "m" : "";
        String postfix = colorDefined ? "\u001b[0m" : "";
        this.style.leftBracket = prefix + this.style.leftBracket;
        this.style.rightBracket = this.style.rightBracket + postfix;
        return this.style;
    }
}

