/*
 * Decompiled with CFR 0.152.
 */
package extractor;

import java.io.FileWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.security.Key;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLSession;

public class MasterSecretCallback {
    private static final Logger log = Logger.getLogger(MasterSecretCallback.class.getName());
    private static String secretsFileName;
    protected static final char[] hexArray;

    public static void setSecretsFileName(String secretsFileName) {
        MasterSecretCallback.secretsFileName = secretsFileName;
    }

    public static void onMasterSecret(SSLSession sslSession, Key masterSecret) {
        try {
            String sessionKey = MasterSecretCallback.bytesToHex(sslSession.getId());
            String masterKey = MasterSecretCallback.bytesToHex(masterSecret.getEncoded());
            FileWriter out = new FileWriter(secretsFileName, true);
            out.write("RSA Session-ID:" + sessionKey + " Master-Key:" + masterKey + "\n");
            ((Writer)out).close();
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Error retrieving master secret from " + sslSession, e);
        }
    }

    public static void onCalculateKeys(SSLSession sslSession, Object randomCookie, Key masterSecret) {
        try {
            String clientRandom = MasterSecretCallback.bytesToHex((byte[])MasterSecretCallback.get(randomCookie, "random_bytes"));
            String masterKey = MasterSecretCallback.bytesToHex(masterSecret.getEncoded());
            FileWriter out = new FileWriter(secretsFileName, true);
            out.write("CLIENT_RANDOM " + clientRandom + " " + masterKey + "\n");
            ((Writer)out).close();
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Error retrieving master secret from " + sslSession, e);
        }
    }

    public static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    private static Object get(Object newObj, String field) throws IllegalAccessException, NoSuchFieldException {
        Field f = newObj.getClass().getDeclaredField(field);
        f.setAccessible(true);
        return f.get(newObj);
    }

    static {
        hexArray = "0123456789ABCDEF".toCharArray();
    }
}

