/*
 * Decompiled with CFR 0.152.
 */
package extractor;

import extractor.MasterSecretCallback;
import extractor.javassist.ClassPool;
import extractor.javassist.CtClass;
import extractor.javassist.CtMethod;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Transformer
implements ClassFileTransformer {
    private static final Logger log = Logger.getLogger(Transformer.class.getName());

    @Override
    public byte[] transform(ClassLoader loader, String classPath, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        String className = classPath.replace("/", ".");
        if (className.equals("sun.security.ssl.SSLSessionImpl") || className.equals("com.sun.net.ssl.internal.ssl.SSLSessionImpl")) {
            try {
                ClassPool pool = ClassPool.getDefault();
                CtClass sslSessionClass = pool.get(className);
                CtMethod method = sslSessionClass.getDeclaredMethod("setMasterSecret");
                method.insertAfter(MasterSecretCallback.class.getName() + ".onMasterSecret(this, $1);");
                return sslSessionClass.toBytecode();
            }
            catch (Throwable e) {
                log.log(Level.WARNING, "Error instrumenting " + className, e);
                return classfileBuffer;
            }
        }
        if (className.equals("sun.security.ssl.Handshaker") || className.equals("com.sun.net.ssl.internal.ssl.Handshaker")) {
            try {
                ClassPool pool = ClassPool.getDefault();
                CtClass sslSessionClass = pool.get(className);
                CtMethod method = sslSessionClass.getDeclaredMethod("calculateConnectionKeys");
                method.insertBefore(MasterSecretCallback.class.getName() + ".onCalculateKeys(session, clnt_random, $1);");
                return sslSessionClass.toBytecode();
            }
            catch (Throwable e) {
                log.log(Level.WARNING, "Error instrumenting " + className, e);
                return classfileBuffer;
            }
        }
        return classfileBuffer;
    }
}

