/*
 * Decompiled with CFR 0.152.
 */
package org.distributeme.core;

import org.configureme.ConfigurationManager;
import org.configureme.annotations.ConfigureMe;
import org.distributeme.core.concurrencycontrol.ConcurrencyControlStrategy;
import org.distributeme.core.concurrencycontrol.UnlimitedConcurrencyStrategy;
import org.distributeme.core.failing.DefaultFailingStrategy;
import org.distributeme.core.failing.FailingStrategy;

public class Defaults {
    private static DefaultsConfiguration config = new DefaultsConfiguration();

    public static final FailingStrategy getDefaultFailingStrategy() {
        return new DefaultFailingStrategy();
    }

    public static final ConcurrencyControlStrategy getDefaultConcurrencyControlStrategy() {
        return new UnlimitedConcurrencyStrategy();
    }

    public static final long getDefaultAsynchCallTimeout() {
        return config.getDefaultAsynchCallTimeout();
    }

    public static final int getAsynchExecutorPoolSize() {
        return config.getAsynchExecutorPoolSize();
    }

    static {
        try {
            ConfigurationManager.INSTANCE.configure((Object)config);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @ConfigureMe(allfields=true, name="distributeme")
    public static class DefaultsConfiguration {
        private String defaultFailingStrategyClassName;
        private String defaultConcurrencyControlStrategyClassName;
        private long defaultAsynchCallTimeout = 10000L;
        private int asynchExecutorPoolSize = 50;

        public String getDefaultFailingStrategyClassName() {
            return this.defaultFailingStrategyClassName;
        }

        public void setDefaultFailingStrategyClassName(String defaultFailingStrategyClassName) {
            this.defaultFailingStrategyClassName = defaultFailingStrategyClassName;
        }

        public String getDefaultConcurrencyControlStrategyClassName() {
            return this.defaultConcurrencyControlStrategyClassName;
        }

        public void setDefaultConcurrencyControlStrategyClassName(String defaultConcurrencyControlStrategyClassName) {
            this.defaultConcurrencyControlStrategyClassName = defaultConcurrencyControlStrategyClassName;
        }

        public long getDefaultAsynchCallTimeout() {
            return this.defaultAsynchCallTimeout;
        }

        public void setDefaultAsynchCallTimeout(long defaultAsynchCallTimeout) {
            this.defaultAsynchCallTimeout = defaultAsynchCallTimeout;
        }

        public int getAsynchExecutorPoolSize() {
            return this.asynchExecutorPoolSize;
        }

        public void setAsynchExecutorPoolSize(int asynchExecutorPoolSize) {
            this.asynchExecutorPoolSize = asynchExecutorPoolSize;
        }
    }
}

