/*
 * Decompiled with CFR 0.152.
 */
package org.distributeme.core;

import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.ExportException;
import java.util.concurrent.atomic.AtomicReference;
import org.distributeme.core.RegistryLocation;
import org.distributeme.core.conventions.SystemProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class RMIRegistryUtil {
    private static Marker fatal = MarkerFactory.getMarker((String)"FATAL");
    private static Logger log = LoggerFactory.getLogger(RMIRegistryUtil.class);
    private static final AtomicReference<Registry> reference = new AtomicReference();
    private static int rmiRegistryPort;

    public static Registry findOrCreateRegistry() throws RemoteException {
        return RMIRegistryUtil.findOrCreateRegistry(-1);
    }

    public static Registry findOrCreateRegistry(int port) throws RemoteException {
        if (reference.get() != null) {
            return reference.get();
        }
        AtomicReference<Registry> atomicReference = reference;
        synchronized (atomicReference) {
            log.info("Creating local registry");
            if (port > 0 || SystemProperties.LOCAL_RMI_REGISTRY_PORT.isSet()) {
                try {
                    if (port <= 0) {
                        port = SystemProperties.LOCAL_RMI_REGISTRY_PORT.getAsInt();
                    }
                    log.info("Tying to bind to " + port);
                    Registry registry = LocateRegistry.createRegistry(port);
                    log.info("Started local registry at port " + port);
                    reference.set(registry);
                    rmiRegistryPort = port;
                    return registry;
                }
                catch (ExportException e) {
                    log.error(fatal, "local rmi registry port specified but not useable", (Throwable)e);
                    throw new AssertionError((Object)("Have to halt due to misconfiguration: local rmi registry port: " + SystemProperties.LOCAL_RMI_REGISTRY_PORT.get() + ", port is not free or not bind-able " + e.getMessage()));
                }
                catch (NumberFormatException e) {
                    log.error(fatal, "local rmi registry port specified but not parseable", (Throwable)e);
                    throw new AssertionError((Object)("Have to halt due to misconfiguration: local rmi registry port: " + SystemProperties.LOCAL_RMI_REGISTRY_PORT.get() + ", expected numeric value."));
                }
            }
            RegistryLocation location = RegistryLocation.create();
            int minPort = location.getRmiRegistryMinPort();
            int maxPort = location.getRmiRegistryMaxPort();
            for (int currentPort = minPort; currentPort <= maxPort; ++currentPort) {
                try {
                    Registry registry = LocateRegistry.createRegistry(currentPort);
                    log.info("Started local registry at port " + currentPort);
                    reference.set(registry);
                    rmiRegistryPort = currentPort;
                    return registry;
                }
                catch (ExportException e) {
                    continue;
                }
            }
            throw new RemoteException("Couldn't obtain free port for a local rmi registry");
        }
    }

    public static int getRmiRegistryPort() {
        return rmiRegistryPort;
    }
}

