/*
 * Decompiled with CFR 0.152.
 */
package org.distributeme.core;

import org.configureme.ConfigurationManager;
import org.configureme.annotations.ConfigureMe;
import org.distributeme.core.Location;
import org.distributeme.core.conventions.SystemProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ConfigureMe(allfields=true, name="distributeme")
public final class RegistryLocation
implements Location {
    private static Logger log = LoggerFactory.getLogger(RegistryLocation.class);
    private String registryContainerHost;
    private int registryContainerPort;
    private int rmiRegistryMinPort = 9250;
    private int rmiRegistryMaxPort = 9299;

    public int getRegistryContainerPort() {
        return this.registryContainerPort;
    }

    public void setRegistryContainerPort(int registryContainerPort) {
        this.registryContainerPort = registryContainerPort;
    }

    public String getRegistryContainerHost() {
        return this.registryContainerHost;
    }

    public void setRegistryContainerHost(String registryContainerHost) {
        this.registryContainerHost = registryContainerHost;
    }

    public int getRmiRegistryMinPort() {
        return this.rmiRegistryMinPort;
    }

    public void setRmiRegistryMinPort(int rmiRegistryMinPort) {
        this.rmiRegistryMinPort = rmiRegistryMinPort;
    }

    public int getRmiRegistryMaxPort() {
        return this.rmiRegistryMaxPort;
    }

    public void setRmiRegistryMaxPort(int rmiRegistryMaxPort) {
        this.rmiRegistryMaxPort = rmiRegistryMaxPort;
    }

    public String toString() {
        return "MetaRegistry " + this.getRegistryContainerHost() + ":" + this.getRegistryContainerPort() + ", local range: [" + this.rmiRegistryMinPort + " .. " + this.rmiRegistryMaxPort + "]";
    }

    public static RegistryLocation create() {
        RegistryLocation location = new RegistryLocation();
        if (location.configureFromSystemPropertiesAndReturnTrueIfConfigured()) {
            return location;
        }
        try {
            ConfigurationManager.INSTANCE.configure((Object)location);
        }
        catch (IllegalArgumentException e) {
            log.warn("Ignore this, if your instance is a registry server: " + e.getMessage());
        }
        return location;
    }

    private boolean configureFromSystemPropertiesAndReturnTrueIfConfigured() {
        this.registryContainerHost = SystemProperties.CENTRAL_REGISTRY_HOST.get();
        this.registryContainerPort = SystemProperties.CENTRAL_REGISTRY_PORT.getAsInt();
        this.rmiRegistryMinPort = SystemProperties.LOCAL_RMI_REGISTRY_MIN_PORT.getAsInt();
        this.rmiRegistryMaxPort = SystemProperties.LOCAL_RMI_REGISTRY_MAX_PORT.getAsInt();
        return this.registryContainerHost != null && this.registryContainerHost.length() > 0;
    }

    private RegistryLocation() {
    }

    @Override
    public String getHost() {
        return this.registryContainerHost;
    }

    @Override
    public int getPort() {
        return this.registryContainerPort;
    }
}

