/*
 * Decompiled with CFR 0.152.
 */
package org.distributeme.core;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.HashMap;
import net.anotheria.util.StringUtils;
import org.configureme.ConfigurationManager;
import org.configureme.annotations.ConfigureMe;
import org.configureme.annotations.Set;
import org.configureme.annotations.SetAll;
import org.distributeme.core.Location;
import org.distributeme.core.ServiceDescriptor;
import org.distributeme.core.util.BaseRegistryUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegistryUtil
extends BaseRegistryUtil {
    public static final String PARAM_ID = "id";
    public static final String APP = "registry";
    private static Logger log = LoggerFactory.getLogger(RegistryUtil.class);
    private static final Configurable configuration = new Configurable();

    public static boolean bind(ServiceDescriptor service) {
        String url = RegistryUtil.createRegistryOperationUrl("bind", "id=" + RegistryUtil.encode(service.getRegistrationString()));
        return RegistryUtil.getSuccessOrError(url);
    }

    public static String ping(Location location) {
        String url = RegistryUtil.createRegistryOperationUrl(location, "ping", "");
        byte[] data = RegistryUtil.getUrlContent(url, true);
        if (data == null) {
            return null;
        }
        String reply = new String(data, Charset.defaultCharset());
        return "ERROR".equals(reply) ? null : reply;
    }

    public static boolean notifyBind(Location location, ServiceDescriptor descriptor) {
        String url = RegistryUtil.createRegistryOperationUrl(location, "nbind", "id=" + RegistryUtil.encode(descriptor.getRegistrationString()));
        return RegistryUtil.getSuccessOrError(url);
    }

    public static boolean notifyUnbind(Location location, ServiceDescriptor descriptor) {
        String url = RegistryUtil.createRegistryOperationUrl(location, "nunbind", "id=" + RegistryUtil.encode(descriptor.getRegistrationString()));
        return RegistryUtil.getSuccessOrError(url);
    }

    public static boolean unbind(ServiceDescriptor service) {
        String url = RegistryUtil.createRegistryOperationUrl("unbind", "id=" + RegistryUtil.encode(service.getRegistrationString()));
        return RegistryUtil.getSuccessOrError(url);
    }

    public static ServiceDescriptor resolve(ServiceDescriptor toResolve, Location loc) {
        String url = RegistryUtil.createRegistryOperationUrl(loc, "resolve", "id=" + RegistryUtil.encode(toResolve.getLookupString()));
        byte[] data = RegistryUtil.getUrlContent(url);
        if (data == null) {
            return null;
        }
        String reply = new String(data, Charset.defaultCharset());
        return "ERROR".equals(reply) ? null : ServiceDescriptor.fromRegistrationString(reply);
    }

    public static String createRegistryOperationUrl(String operation, String parameters) {
        return RegistryUtil.getRegistryBaseUrl() + operation + "?" + parameters;
    }

    public static String createRegistryOperationUrl(Location loc, String operation, String parameters) {
        return RegistryUtil.getRegistryBaseUrl(loc.getHost(), loc.getPort()) + operation + "?" + parameters;
    }

    public static String getXMLServiceList() {
        return RegistryUtil.getXMLServiceList(registryLocation);
    }

    public static String getXMLServiceList(Location loc) {
        String url = RegistryUtil.getRegistryBaseUrl(loc.getHost(), loc.getPort()) + "list";
        byte[] data = RegistryUtil.getUrlContent(url);
        if (data == null) {
            return null;
        }
        String reply = new String(data);
        return reply;
    }

    public static ServiceDescriptor resolve(ServiceDescriptor toResolve) {
        return RegistryUtil.resolve(toResolve, registryLocation);
    }

    protected static String getRegistryBaseUrl() {
        return RegistryUtil.getRegistryBaseUrl(APP);
    }

    protected static String getRegistryBaseUrl(String host, int port) {
        return RegistryUtil.getRegistryBaseUrl(APP, host, port);
    }

    public static ServiceDescriptor createLocalServiceDescription(ServiceDescriptor.Protocol protocol, String serviceId, String instanceId, int port) {
        return new ServiceDescriptor(protocol, serviceId, instanceId, RegistryUtil.getHostName(), port);
    }

    private static String getHostName() {
        try {
            InetAddress localhost = InetAddress.getLocalHost();
            String host = localhost.getHostAddress();
            HashMap<String, String> mappings = configuration.getMappings();
            String mappedHost = mappings.get(host);
            return mappedHost == null ? host : mappedHost;
        }
        catch (UnknownHostException e) {
            return "unknown";
        }
    }

    private static boolean getSuccessOrError(String url) {
        byte[] data = RegistryUtil.getUrlContent(url);
        return data != null && new String(data).equals("SUCCESS");
    }

    public static final String describeRegistry() {
        return registryLocation.toString();
    }

    static {
        try {
            ConfigurationManager.INSTANCE.configure((Object)configuration);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @ConfigureMe(name="distributeme", watch=true)
    public static class Configurable {
        private volatile HashMap<String, String> mappings = new HashMap();

        @Set(value="registrationIpMapping")
        public void setRegistrationIpMapping(String registrationIpMapping) {
            log.info("registrationIpMappingSet: " + registrationIpMapping);
            try {
                String[] pairs;
                HashMap<String, String> newMappings = new HashMap<String, String>();
                for (String p : pairs = StringUtils.tokenize((String)registrationIpMapping, (char)',')) {
                    String[] ips = StringUtils.tokenize((String)p, (char)':');
                    newMappings.put(ips[0], ips[1]);
                }
                this.mappings = newMappings;
            }
            catch (Exception e) {
                log.warn("setRegistrationIpMapping(" + registrationIpMapping + "), e");
            }
        }

        @SetAll
        public void debug(String key, String value) {
            log.debug("Config " + key + "=" + value);
        }

        public HashMap<String, String> getMappings() {
            return this.mappings;
        }

        public String toString() {
            return "Configurable mappings: " + this.mappings;
        }
    }
}

