/*
 * Decompiled with CFR 0.152.
 */
package org.distributeme.core;

import java.io.Serializable;
import java.util.Calendar;
import net.anotheria.util.BasicComparable;

public class ServiceDescriptor
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 2854220693966853387L;
    public static final String PROTOCOL_SEPARATOR = "://";
    public static final char HOST_SEPARATOR = '@';
    public static final char PORT_SEPARATOR = ':';
    public static final char INSTANCE_SEPARATOR = '.';
    public static final char TIMESTAMP_SEPARATOR = '@';
    private Protocol protocol;
    private String serviceId;
    private String host;
    private int port;
    private String instanceId;
    private long timestamp;

    public ServiceDescriptor(Protocol aProtocol, String aServiceId, String anInstanceId, String aHost, int aPort) {
        this(aProtocol, aServiceId, anInstanceId, aHost, aPort, 0L);
    }

    public ServiceDescriptor(Protocol aProtocol, String aServiceId, String anInstanceId, String aHost, int aPort, long aTimestamp) {
        if (aProtocol == null) {
            throw new IllegalArgumentException("Null protocol is not allowed");
        }
        if (aServiceId == null || aServiceId.equals("")) {
            throw new IllegalArgumentException("Null or empty serviceId is not allowed");
        }
        if (anInstanceId == null || anInstanceId.equals("")) {
            throw new IllegalArgumentException("Null or empty instanceId is not allowed");
        }
        if (aHost == null || aHost.equals("")) {
            throw new IllegalArgumentException("Null or empty host is not allowed");
        }
        this.protocol = aProtocol;
        this.serviceId = aServiceId;
        this.instanceId = anInstanceId;
        this.host = aHost;
        this.port = aPort;
        this.timestamp = aTimestamp > 0L ? aTimestamp : System.currentTimeMillis();
    }

    public ServiceDescriptor(Protocol aProtocol, String aServiceId) {
        if (aProtocol == null) {
            throw new IllegalArgumentException("Null protocol is not allowed");
        }
        if (aServiceId == null || aServiceId.equals("")) {
            throw new IllegalArgumentException("Null or empty serviceId is not allowed");
        }
        this.protocol = aProtocol;
        this.serviceId = aServiceId;
    }

    public String getGlobalServiceId() {
        return this.protocol.toString().toLowerCase() + PROTOCOL_SEPARATOR + this.serviceId;
    }

    public String getRegistrationString() {
        return this.getGlobalServiceId() + '.' + this.instanceId + '@' + this.host + ':' + this.port + '@' + ServiceDescriptor.getTimeString(this.timestamp);
    }

    public String getLookupString() {
        return this.getGlobalServiceId();
    }

    public String toString() {
        return this.getRegistrationString();
    }

    public final String getSystemWideUniqueId() {
        return this.getRegistrationString();
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public static final ServiceDescriptor fromSystemWideUniqueId(String systemWideUniqueId) {
        return ServiceDescriptor.fromRegistrationString(systemWideUniqueId);
    }

    public static final ServiceDescriptor fromRegistrationString(String registrationString) {
        int indexOfHost = registrationString.indexOf(64);
        long timestamp = 0L;
        int indexOfTimestamp = registrationString.substring(indexOfHost + 1).indexOf(64);
        if (indexOfTimestamp >= 0) {
            timestamp = ServiceDescriptor.parseTimeString(registrationString.substring((indexOfTimestamp += indexOfHost + 1) + 1));
        } else {
            indexOfTimestamp = registrationString.length();
        }
        String hostAndPort = registrationString.substring(indexOfHost + 1, indexOfTimestamp);
        String protocolAndServiceId = registrationString.substring(0, indexOfHost);
        int portSeparatorPos = hostAndPort.lastIndexOf(58);
        String host = hostAndPort.substring(0, portSeparatorPos);
        String port = hostAndPort.substring(portSeparatorPos + 1, hostAndPort.length());
        String protocol = protocolAndServiceId.substring(0, protocolAndServiceId.indexOf(58));
        String serviceAndInstanceId = protocolAndServiceId.substring(protocolAndServiceId.indexOf(47) + 2);
        int indexOfInstanceIdSeparator = serviceAndInstanceId.lastIndexOf(46);
        String serviceId = serviceAndInstanceId.substring(0, indexOfInstanceIdSeparator);
        String instanceId = serviceAndInstanceId.substring(indexOfInstanceIdSeparator + 1);
        return new ServiceDescriptor(Protocol.valueOf(protocol.toUpperCase()), serviceId, instanceId, host, Integer.parseInt(port), timestamp);
    }

    public static final ServiceDescriptor fromResolveString(String resolveString) {
        String protocol = resolveString.substring(0, resolveString.indexOf(58));
        String serviceId = resolveString.substring(resolveString.indexOf(47) + 2);
        return new ServiceDescriptor(Protocol.valueOf(protocol.toUpperCase()), serviceId);
    }

    public ServiceDescriptor changeServiceId(String aServiceId) {
        try {
            ServiceDescriptor newSD = (ServiceDescriptor)this.clone();
            newSD.serviceId = aServiceId;
            return newSD;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)"Can't happen");
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.host == null ? 0 : this.host.hashCode());
        result = 31 * result + this.port;
        result = 31 * result + (this.protocol == null ? 0 : this.protocol.hashCode());
        result = 31 * result + (this.serviceId == null ? 0 : this.serviceId.hashCode());
        result = 31 * result + (this.instanceId == null ? 0 : this.instanceId.hashCode());
        return result;
    }

    public boolean equals(Object o) {
        return o instanceof ServiceDescriptor ? this.protocol == ((ServiceDescriptor)o).protocol && this.port == ((ServiceDescriptor)o).port && BasicComparable.compareString((String)this.host, (String)((ServiceDescriptor)o).host) == 0 && BasicComparable.compareString((String)this.serviceId, (String)((ServiceDescriptor)o).serviceId) == 0 && BasicComparable.compareString((String)this.instanceId, (String)((ServiceDescriptor)o).instanceId) == 0 : false;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getProtocol() {
        return this.protocol.toString().toLowerCase();
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public static String getTimeString(long timestamp) {
        assert (timestamp > 0L);
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(timestamp);
        return String.format("%04d%02d%02d%02d%02d%02d", calendar.get(1), calendar.get(2) + 1, calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13));
    }

    public static long parseTimeString(String s) {
        assert (s != null);
        int[] numChars = new int[]{4, 2, 2, 2, 2, 2};
        int[] vals = new int[numChars.length];
        Calendar calendar = Calendar.getInstance();
        try {
            int j = 0;
            for (int i = 0; i < numChars.length; ++i) {
                vals[i] = Integer.parseInt(s.substring(j, j + numChars[i]), 10);
                j += numChars[i];
            }
        }
        catch (IndexOutOfBoundsException e) {
            return 0L;
        }
        catch (NumberFormatException e) {
            return 0L;
        }
        calendar.set(vals[0], vals[1] - 1, vals[2], vals[3], vals[4], vals[5]);
        return calendar.getTimeInMillis();
    }

    public static enum Protocol {
        RMI,
        JAXWS,
        CORBA,
        JAXRS;

    }
}

