/*
 * Decompiled with CFR 0.152.
 */
package org.distributeme.core;

import net.anotheria.anoprise.metafactory.Extension;
import net.anotheria.anoprise.metafactory.MetaFactory;
import net.anotheria.anoprise.metafactory.MetaFactoryException;
import net.anotheria.anoprise.metafactory.Service;
import net.anotheria.moskito.core.dynamic.ProxyUtils;
import org.distributeme.core.conventions.SharedNamingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceLocator {
    private static Logger log = LoggerFactory.getLogger(ServiceLocator.class);

    public static <T extends Service> T getAsynchRemote(Class<T> pattern) {
        try {
            return (T)MetaFactory.get(pattern, (Extension)Extension.ASYNCH);
        }
        catch (MetaFactoryException metaFactoryException) {
            String className = SharedNamingUtils.getAsynchFactoryFullClassName(pattern);
            try {
                Class<?> factoryClazz = Class.forName(className);
                MetaFactory.addFactoryClass(pattern, (Extension)Extension.ASYNCH, factoryClazz);
            }
            catch (ClassNotFoundException ignored) {
                ignored.printStackTrace();
            }
            try {
                return (T)MetaFactory.get(pattern, (Extension)Extension.ASYNCH);
            }
            catch (MetaFactoryException e) {
                log.error("getAsynchRemote(" + pattern + ")", (Throwable)e);
                throw new RuntimeException("No asynch impl for " + pattern.getName() + " known (tried MetaFactory.get(" + pattern.getName() + " and " + className + ")");
            }
        }
    }

    public static <T extends Service> T getRemote(Class<T> pattern) {
        try {
            return (T)MetaFactory.get(pattern, (Extension)Extension.REMOTE);
        }
        catch (MetaFactoryException metaFactoryException) {
            String className = SharedNamingUtils.getStubFactoryFullClassName(pattern);
            try {
                Class<?> factoryClazz = Class.forName(className);
                MetaFactory.addFactoryClass(pattern, (Extension)Extension.REMOTE, factoryClazz);
            }
            catch (ClassNotFoundException ignored) {
                ignored.printStackTrace();
            }
            try {
                return (T)MetaFactory.get(pattern, (Extension)Extension.REMOTE);
            }
            catch (MetaFactoryException e) {
                log.error("getRemote(" + pattern + ")", (Throwable)e);
                throw new RuntimeException("No remote impl for " + pattern.getName() + " known (tried MetaFactory.get(" + pattern.getName() + " and " + className + ")");
            }
        }
    }

    public static <T extends Service> T getLocal(Class<T> pattern) {
        try {
            return (T)MetaFactory.get(pattern, (Extension)Extension.LOCAL);
        }
        catch (MetaFactoryException metaFactoryException) {
            String patternName = pattern.getName();
            String factoryName = patternName + "Factory";
            String implName = patternName + "Impl";
            try {
                log.debug("looking up factory " + factoryName + " for service " + patternName);
                Class<?> factoryClazz = Class.forName(factoryName);
                MetaFactory.addFactoryClass(pattern, (Extension)Extension.LOCAL, factoryClazz);
            }
            catch (ClassNotFoundException factoryNotFound) {
                try {
                    log.debug("looking up impl " + implName + " for service " + patternName);
                    Class<?> implClazz = Class.forName(implName);
                    MetaFactory.createOnTheFlyFactory(pattern, (Extension)Extension.LOCAL, (Service)((Service)implClazz.newInstance()));
                }
                catch (ClassNotFoundException implNotFound) {
                    log.warn("Giving up trying to find an impl instance, tried " + implName + " and " + factoryName);
                }
                catch (InstantiationException e) {
                    log.warn("Found implementation " + implName + " but failed to instantiate, ", (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    log.warn("Found implementation " + implName + " but failed to instantiate due", (Throwable)e);
                }
            }
            try {
                return (T)MetaFactory.get(pattern, (Extension)Extension.LOCAL);
            }
            catch (MetaFactoryException e) {
                throw new IllegalArgumentException(pattern + " doesn't seem to be dynamically resolveable, its missing " + implName + " or " + factoryName);
            }
        }
    }

    public static <T extends Service> T getMonitoredLocal(Class<T> pattern, Class<?> ... monitorableInterfaces) {
        T serviceInstance = ServiceLocator.getLocal(pattern);
        return (T)((Service)ProxyUtils.createServiceInstance(serviceInstance, (String)"default", pattern, (Class[])monitorableInterfaces));
    }
}

