/*
 * Decompiled with CFR 0.152.
 */
package org.distributeme.core.asynch;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.distributeme.core.Defaults;
import org.distributeme.core.asynch.CallBackHandler;

public class MultiCallCollector {
    private final CountDownLatch latch;
    private ConcurrentMap<String, SubCallBackHandler> handlers;
    private int numberOfCalls;

    public MultiCallCollector(int aNumberOfCalls) {
        this.numberOfCalls = aNumberOfCalls;
        this.latch = new CountDownLatch(this.numberOfCalls);
        this.handlers = new ConcurrentHashMap<String, SubCallBackHandler>();
    }

    public void waitForResults(long timeout) throws InterruptedException {
        this.latch.await(timeout, TimeUnit.MILLISECONDS);
    }

    public void waitForResults() throws InterruptedException {
        this.waitForResults(Defaults.getDefaultAsynchCallTimeout());
    }

    public boolean isFinished() {
        return this.latch.getCount() == 0L;
    }

    public CallBackHandler createSubCallHandler(String id) {
        if (this.handlers.size() >= this.numberOfCalls) {
            throw new IllegalStateException("There are already " + this.numberOfCalls + " calls running");
        }
        SubCallBackHandler newHandler = new SubCallBackHandler(this);
        if (this.handlers.putIfAbsent(id, newHandler) != null) {
            throw new IllegalArgumentException("Call with id " + id + " is already started!");
        }
        return newHandler;
    }

    protected void notifySubCallFinished() {
        this.latch.countDown();
    }

    private SubCallBackHandler getHandler(String id) {
        return (SubCallBackHandler)this.handlers.get(id);
    }

    public boolean isError(String id) {
        return this.isFinished() && this.getHandler(id).returnException != null;
    }

    public boolean isSuccess(String id) {
        return this.isFinished() && this.getHandler(id).returnException == null;
    }

    public Object getReturnValue(String id) {
        return this.getHandler(id).returnValue;
    }

    public Exception getReturnException(String id) {
        return this.getHandler(id).returnException;
    }

    public static class SubCallBackHandler
    implements CallBackHandler {
        private MultiCallCollector parent;
        private volatile Object returnValue;
        private volatile Exception returnException;

        public SubCallBackHandler(MultiCallCollector aParent) {
            this.parent = aParent;
        }

        @Override
        public void success(Object o) {
            this.returnValue = o;
            this.parent.notifySubCallFinished();
        }

        @Override
        public void error(Exception e) {
            this.returnException = e;
            this.parent.notifySubCallFinished();
        }
    }
}

