/*
 * Decompiled with CFR 0.152.
 */
package org.distributeme.core.asynch;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.distributeme.core.Defaults;
import org.distributeme.core.asynch.CallBackHandler;

public class SingleCallHandler
implements CallBackHandler {
    private Object returnValue;
    private Exception returnException;
    private final CountDownLatch latch = new CountDownLatch(1);

    public void waitForResults(long timeout) throws InterruptedException {
        this.latch.await(timeout, TimeUnit.MILLISECONDS);
    }

    public void waitForResults() throws InterruptedException {
        this.waitForResults(Defaults.getDefaultAsynchCallTimeout());
    }

    public boolean isFinished() {
        return this.latch.getCount() == 0L;
    }

    private void markFinished() {
        this.latch.countDown();
    }

    @Override
    public void success(Object o) {
        this.returnValue = o;
        this.markFinished();
    }

    @Override
    public void error(Exception e) {
        this.returnException = e;
        this.markFinished();
    }

    public boolean isError() {
        return this.isFinished() && this.returnException != null;
    }

    public boolean isSuccess() {
        return this.isFinished() && this.returnException == null;
    }

    public Object getReturnValue() {
        return this.returnValue;
    }

    public Exception getReturnException() {
        return this.returnException;
    }
}

