/*
 * Decompiled with CFR 0.152.
 */
package org.distributeme.core.concurrencycontrol;

import java.util.concurrent.atomic.AtomicLong;
import net.anotheria.util.StringUtils;
import org.configureme.ConfigurationManager;
import org.distributeme.core.ClientSideCallContext;
import org.distributeme.core.ServerSideCallContext;
import org.distributeme.core.concurrencycontrol.ConcurrencyControlStrategy;
import org.distributeme.core.concurrencycontrol.ConcurrencyControlStrategyConfiguration;
import org.distributeme.core.concurrencycontrol.OutgoingRequestRefusedException;
import org.distributeme.core.concurrencycontrol.ServerRefusedRequestException;

public class ConfigurationBasedConcurrencyControlStrategy
implements ConcurrencyControlStrategy {
    private ConcurrencyControlStrategyConfiguration configuration = new ConcurrencyControlStrategyConfiguration();
    private AtomicLong clientSideRequestCount = new AtomicLong(0L);
    private AtomicLong serverSideRequestCount = new AtomicLong(0L);

    @Override
    public void customize(String parameter) {
        if (parameter.indexOf(44) != -1) {
            this.customizeFromAnnotationParameter(parameter);
        } else {
            this.customizeFromConfigurationName(parameter);
        }
    }

    private void customizeFromConfigurationName(String parameter) {
        try {
            ConfigurationManager.INSTANCE.configureAs((Object)this.configuration, parameter);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Can't find configuration " + parameter + " for concurrency config");
        }
    }

    private void customizeFromAnnotationParameter(String parameter) {
        if (parameter == null || parameter.length() == 0) {
            throw new IllegalArgumentException("Empty or null parameter, expected clientlimit,serverlimit");
        }
        String[] limits = StringUtils.tokenize((String)parameter, (char)',');
        int aClientSideLimit = Integer.parseInt(limits[0]);
        if (aClientSideLimit > 0) {
            this.configuration.setClientSideLimit(aClientSideLimit);
        }
        int aServerSideLimit = 0;
        if (limits.length > 1) {
            aServerSideLimit = Integer.parseInt(limits[1]);
        }
        if (aServerSideLimit > 0) {
            this.configuration.setServerSideLimit(aServerSideLimit);
        }
    }

    @Override
    public void notifyClientSideCallStarted(ClientSideCallContext context) {
        if (this.clientSideRequestCount.incrementAndGet() > (long)this.configuration.getClientSideLimit()) {
            this.clientSideRequestCount.decrementAndGet();
            throw new OutgoingRequestRefusedException();
        }
    }

    @Override
    public void notifyClientSideCallFinished(ClientSideCallContext context) {
        this.clientSideRequestCount.decrementAndGet();
    }

    @Override
    public void notifyServerSideCallStarted(ServerSideCallContext context) {
        if (this.serverSideRequestCount.incrementAndGet() > (long)this.configuration.getServerSideLimit()) {
            this.serverSideRequestCount.decrementAndGet();
            throw new ServerRefusedRequestException();
        }
    }

    @Override
    public void notifyServerSideCallFinished(ServerSideCallContext context) {
        this.serverSideRequestCount.decrementAndGet();
    }

    public String toString() {
        return this.getClass().getSimpleName() + " with limits configuration: " + this.configuration;
    }
}

