/*
 * Decompiled with CFR 0.152.
 */
package org.distributeme.core.concurrencycontrol;

import java.util.concurrent.atomic.AtomicLong;
import net.anotheria.util.StringUtils;
import org.distributeme.core.ClientSideCallContext;
import org.distributeme.core.ServerSideCallContext;
import org.distributeme.core.concurrencycontrol.ConcurrencyControlStrategy;
import org.distributeme.core.concurrencycontrol.OutgoingRequestRefusedException;
import org.distributeme.core.concurrencycontrol.ServerRefusedRequestException;

public class ConstantBasedConcurrencyControlStrategy
implements ConcurrencyControlStrategy {
    private int clientSideLimit = Integer.MAX_VALUE;
    private int serverSideLimit = Integer.MAX_VALUE;
    private AtomicLong clientSideRequestCount = new AtomicLong(0L);
    private AtomicLong serverSideRequestCount = new AtomicLong(0L);

    @Override
    public void customize(String parameter) {
        if (parameter == null || parameter.length() == 0) {
            throw new IllegalArgumentException("Empty or null parameter, expected clientlimit,serverlimit");
        }
        String[] limits = StringUtils.tokenize((String)parameter, (char)',');
        int aClientSideLimit = Integer.parseInt(limits[0]);
        if (aClientSideLimit > 0) {
            this.clientSideLimit = aClientSideLimit;
        }
        int aServerSideLimit = 0;
        if (limits.length > 1) {
            aServerSideLimit = Integer.parseInt(limits[1]);
        }
        if (aServerSideLimit > 0) {
            this.serverSideLimit = aServerSideLimit;
        }
    }

    @Override
    public void notifyClientSideCallStarted(ClientSideCallContext context) {
        if (this.clientSideRequestCount.incrementAndGet() > (long)this.clientSideLimit) {
            this.clientSideRequestCount.decrementAndGet();
            throw new OutgoingRequestRefusedException();
        }
    }

    @Override
    public void notifyClientSideCallFinished(ClientSideCallContext context) {
        this.clientSideRequestCount.decrementAndGet();
    }

    @Override
    public void notifyServerSideCallStarted(ServerSideCallContext context) {
        if (this.serverSideRequestCount.incrementAndGet() > (long)this.serverSideLimit) {
            this.serverSideRequestCount.decrementAndGet();
            throw new ServerRefusedRequestException();
        }
    }

    @Override
    public void notifyServerSideCallFinished(ServerSideCallContext context) {
        this.serverSideRequestCount.decrementAndGet();
    }

    public String toString() {
        return this.getClass().getSimpleName() + " with limits (" + this.clientSideLimit + ", " + this.serverSideLimit + ")";
    }
}

