/*
 * Decompiled with CFR 0.152.
 */
package org.distributeme.core.conventions;

public enum SystemProperties {
    SKIP_CENTRAL_REGISTRY("skipCentralRegistry", "false"),
    LOCAL_RMI_REGISTRY_PORT("localRmiRegistryPort", null),
    CENTRAL_REGISTRY_HOST("registryContainerHost", null),
    CENTRAL_REGISTRY_PORT("registryContainerPort", "9229"),
    LOCAL_RMI_REGISTRY_MIN_PORT("localRmiRegistryMinPort", "9250"),
    LOCAL_RMI_REGISTRY_MAX_PORT("localRmiRegistryMaxPort", "9299"),
    SERVICE_BINDING_PORT("serviceBindingPort", "0");

    private String propertyName;
    private String defaultValue;

    private SystemProperties(String aPropertyName, String aDefaultValue) {
        this.propertyName = aPropertyName;
        this.defaultValue = aDefaultValue;
    }

    public boolean isSet() {
        return this.get() != null;
    }

    public String get() {
        return System.getProperty(this.propertyName, this.defaultValue);
    }

    public boolean getAsBoolean() {
        return Boolean.parseBoolean(this.get());
    }

    public int getAsInt() {
        return Integer.parseInt(this.get());
    }
}

