/*
 * Decompiled with CFR 0.152.
 */
package org.distributeme.core.failing;

import org.distributeme.core.ClientSideCallContext;
import org.distributeme.core.failing.FailDecision;
import org.distributeme.core.failing.FailingStrategy;
import org.distributeme.core.routing.AbstractRouter;
import org.distributeme.core.routing.RegistrationNameProvider;
import org.distributeme.core.routing.Router;

public abstract class FailoverAndReturn
extends AbstractRouter
implements FailingStrategy,
RegistrationNameProvider,
Router {
    private String failedOverServiceId = null;
    private long failoverTimestamp = 0L;
    protected static final long SECOND = 1000L;
    protected static final long MINUTE = 60000L;
    public static final String SUFFIX = "-failover";

    protected abstract long getFailbackTimeout();

    @Override
    public String getServiceIdForCall(ClientSideCallContext callContext) {
        if (this.failoverTimestamp != 0L && callContext.isFirstCall() && System.currentTimeMillis() - this.failoverTimestamp > this.getFailbackTimeout()) {
            this.failoverTimestamp = 0L;
            this.failedOverServiceId = null;
        }
        if (!callContext.isFirstCall() && this.failedOverServiceId == null) {
            this.failedOverServiceId = callContext.getServiceId();
            this.failoverTimestamp = System.currentTimeMillis();
        }
        String ret = this.failedOverServiceId == null ? callContext.getServiceId() : this.failedOverServiceId;
        return ret;
    }

    @Override
    public String getRegistrationName(String serviceId) {
        return serviceId + SUFFIX;
    }

    @Override
    public void customize(String parameter) {
    }

    @Override
    public FailDecision callFailed(ClientSideCallContext context) {
        FailDecision ret = FailDecision.retryOnce();
        ret.setTargetService(context.getServiceId() + this.getSuffix());
        return ret;
    }

    protected String getSuffix() {
        return SUFFIX;
    }
}

