/*
 * Decompiled with CFR 0.152.
 */
package org.distributeme.core.interceptor;

import java.util.ArrayList;
import java.util.List;
import net.anotheria.util.BasicComparable;
import net.anotheria.util.sorter.DummySortType;
import net.anotheria.util.sorter.IComparable;
import net.anotheria.util.sorter.SortType;
import net.anotheria.util.sorter.StaticQuickSorter;
import org.configureme.ConfigurationManager;
import org.configureme.annotations.AfterConfiguration;
import org.configureme.annotations.Configure;
import org.configureme.annotations.ConfigureMe;
import org.configureme.annotations.SetIf;
import org.distributeme.core.interceptor.ClientSideRequestInterceptor;
import org.distributeme.core.interceptor.ServerSideRequestInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InterceptorRegistry {
    private static final InterceptorRegistry instance;
    private static Logger log;
    private volatile List<ClientSideRequestInterceptor> clientSideInterceptors = new ArrayList<ClientSideRequestInterceptor>();
    private volatile List<ServerSideRequestInterceptor> serverSideInterceptors = new ArrayList<ServerSideRequestInterceptor>();

    public static final InterceptorRegistry getInstance() {
        return instance;
    }

    private InterceptorRegistry() {
    }

    public List<ClientSideRequestInterceptor> getClientSideRequestInterceptors() {
        return this.clientSideInterceptors;
    }

    public List<ServerSideRequestInterceptor> getServerSideRequestInterceptors() {
        return this.serverSideInterceptors;
    }

    static void buildInterceptors(List<InterceptorEntry> entries, String[] interceptorNames) {
        ArrayList<ClientSideRequestInterceptor> clientSide = new ArrayList<ClientSideRequestInterceptor>();
        ArrayList<ServerSideRequestInterceptor> serverSide = new ArrayList<ServerSideRequestInterceptor>();
        for (InterceptorEntry entry : entries) {
            try {
                Object interceptorInstance = Class.forName(entry.clazzName).newInstance();
                if (interceptorInstance instanceof ClientSideRequestInterceptor) {
                    clientSide.add((ClientSideRequestInterceptor)interceptorInstance);
                }
                if (!(interceptorInstance instanceof ServerSideRequestInterceptor)) continue;
                serverSide.add((ServerSideRequestInterceptor)interceptorInstance);
            }
            catch (InstantiationException e) {
                log.error("buildInterceptors(... " + entry.clazzName + ")", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                log.error("buildInterceptors(... " + entry.clazzName + ")", (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                log.error("buildInterceptors(... " + entry.clazzName + ")", (Throwable)e);
            }
        }
        if (interceptorNames != null) {
            for (String interceptorName : interceptorNames) {
                try {
                    Object interceptorInstance = Class.forName(interceptorName).newInstance();
                    if (interceptorInstance instanceof ClientSideRequestInterceptor) {
                        clientSide.add((ClientSideRequestInterceptor)interceptorInstance);
                    }
                    if (!(interceptorInstance instanceof ServerSideRequestInterceptor)) continue;
                    serverSide.add((ServerSideRequestInterceptor)interceptorInstance);
                }
                catch (InstantiationException e) {
                    log.error("buildInterceptors(... " + interceptorName + ")", (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    log.error("buildInterceptors(... " + interceptorName + ")", (Throwable)e);
                }
                catch (ClassNotFoundException e) {
                    log.error("buildInterceptors(... " + interceptorName + ")", (Throwable)e);
                }
            }
        }
        InterceptorRegistry.instance.clientSideInterceptors = clientSide;
        InterceptorRegistry.instance.serverSideInterceptors = serverSide;
    }

    static {
        log = LoggerFactory.getLogger(InterceptorRegistry.class);
        instance = new InterceptorRegistry();
        Config config = new Config();
        try {
            ConfigurationManager.INSTANCE.configure((Object)config);
        }
        catch (IllegalArgumentException e) {
            LoggerFactory.getLogger(InterceptorRegistry.class).warn("No DistributeMe config (distributeme.json), interceptors aren't configured either");
        }
    }

    static class InterceptorEntry
    implements IComparable<InterceptorEntry> {
        private int number;
        private String clazzName;

        InterceptorEntry(int aNumber, String aClazzName) {
            this.number = aNumber;
            this.clazzName = aClazzName;
        }

        public int compareTo(IComparable<? extends InterceptorEntry> anotherEntry, int arg1) {
            return BasicComparable.compareInt((int)this.number, (int)((InterceptorEntry)anotherEntry).number);
        }
    }

    @ConfigureMe(name="distributeme")
    public static class Config {
        @Configure
        private String[] interceptors;
        private List<InterceptorEntry> interceptorEntries = new ArrayList<InterceptorEntry>();

        @AfterConfiguration
        public void reconfigure() {
            InterceptorRegistry.buildInterceptors(StaticQuickSorter.sort(this.interceptorEntries, (SortType)new DummySortType()), this.interceptors);
        }

        public void setInterceptors(String[] someInterceptors) {
            this.interceptors = someInterceptors;
        }

        @SetIf(condition=SetIf.SetIfCondition.startsWith, value="interceptor.")
        public void addInterceptor(String interceptorKey, String clazzName) {
            int indexOfDot = interceptorKey.indexOf(46);
            int interceptorNumber = Integer.parseInt(interceptorKey.substring(indexOfDot + 1));
            this.interceptorEntries.add(new InterceptorEntry(interceptorNumber, clazzName));
        }
    }
}

