/*
 * Decompiled with CFR 0.152.
 */
package org.distributeme.core.interceptor;

public class InterceptorResponse {
    private Exception exception;
    private Object returnValue;
    private InterceptorCommand command;
    public static final InterceptorResponse CONTINUE = new InterceptorResponse(InterceptorCommand.CONTINUE);
    public static final InterceptorResponse RETURN_AND_FAIL = new InterceptorResponse(InterceptorCommand.RETURN_AND_FAIL);
    public static final InterceptorResponse ABORT_AND_FAIL = new InterceptorResponse(InterceptorCommand.ABORT_AND_FAIL);

    public InterceptorResponse(InterceptorCommand aCommand) {
        this.command = aCommand;
    }

    public InterceptorCommand getCommand() {
        return this.command;
    }

    public String toString() {
        return "InterceptionResponse " + (Object)((Object)this.getCommand());
    }

    public Exception getException() {
        return this.exception;
    }

    public Object getReturnValue() {
        return this.returnValue;
    }

    public static final InterceptorResponse returnNow(Object returnValue) {
        InterceptorResponse response = new InterceptorResponse(InterceptorCommand.RETURN);
        response.returnValue = returnValue;
        return response;
    }

    public static final InterceptorResponse returnLater(Object returnValue) {
        InterceptorResponse response = new InterceptorResponse(InterceptorCommand.OVERWRITE_RETURN_AND_CONTINUE);
        response.returnValue = returnValue;
        return response;
    }

    public static final InterceptorResponse abortNow(Exception anException) {
        InterceptorResponse response = new InterceptorResponse(InterceptorCommand.ABORT);
        response.exception = anException;
        return response;
    }

    public static enum InterceptorCommand {
        CONTINUE,
        ABORT,
        RETURN,
        OVERWRITE_RETURN_AND_CONTINUE,
        ABORT_AND_FAIL,
        RETURN_AND_FAIL;

    }
}

