/*
 * Decompiled with CFR 0.152.
 */
package org.distributeme.core.interceptor;

import java.util.HashSet;
import org.distributeme.core.AbstractCallContext;
import org.distributeme.core.ClientSideCallContext;
import org.distributeme.core.ServerSideCallContext;
import org.distributeme.core.interceptor.AbstractRequestInterceptor;
import org.distributeme.core.interceptor.InterceptionContext;
import org.distributeme.core.interceptor.InterceptionPhase;
import org.distributeme.core.interceptor.InterceptorResponse;

public abstract class SinglePhaseInterceptor
extends AbstractRequestInterceptor {
    private HashSet<InterceptionPhase> supportedPhases = new HashSet();

    protected SinglePhaseInterceptor(InterceptionPhase atLeastOne, InterceptionPhase ... phases) {
        this.supportedPhases.add(atLeastOne);
        if (phases != null) {
            for (InterceptionPhase p : phases) {
                this.supportedPhases.add(p);
            }
        }
    }

    @Override
    public final InterceptorResponse beforeServantCall(ServerSideCallContext context, InterceptionContext iContext) {
        if (this.supportedPhases.contains((Object)InterceptionPhase.BEFORE_SERVANT_CALL)) {
            return this.processPhase(context, iContext);
        }
        return super.beforeServantCall(context, iContext);
    }

    @Override
    public final InterceptorResponse afterServantCall(ServerSideCallContext context, InterceptionContext iContext) {
        if (this.supportedPhases.contains((Object)InterceptionPhase.AFTER_SERVANT_CALL)) {
            return this.processPhase(context, iContext);
        }
        return super.afterServantCall(context, iContext);
    }

    @Override
    public final InterceptorResponse beforeServiceCall(ClientSideCallContext context, InterceptionContext iContext) {
        if (this.supportedPhases.contains((Object)InterceptionPhase.BEFORE_SERVICE_CALL)) {
            return this.processPhase(context, iContext);
        }
        return super.beforeServiceCall(context, iContext);
    }

    @Override
    public final InterceptorResponse afterServiceCall(ClientSideCallContext context, InterceptionContext iContext) {
        if (this.supportedPhases.contains((Object)InterceptionPhase.AFTER_SERVICE_CALL)) {
            return this.processPhase(context, iContext);
        }
        return super.afterServiceCall(context, iContext);
    }

    protected abstract InterceptorResponse processPhase(AbstractCallContext var1, InterceptionContext var2);
}

