/*
 * Decompiled with CFR 0.152.
 */
package org.distributeme.core.interceptor.availabilitytesting;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.configureme.ConfigurationManager;
import org.configureme.annotations.AfterConfiguration;
import org.configureme.annotations.ConfigureMe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationInterceptorUtil {
    private static Logger log = LoggerFactory.getLogger(ConfigurationInterceptorUtil.class);
    private static Random rnd = new Random(System.nanoTime());
    private static ConfigurationObject config;

    public static final long getSlowDownTime() {
        return config.getSlowDownTimeInMillis();
    }

    public static final boolean flip() {
        if (config.getFlipChanceInPercent() == 0) {
            return false;
        }
        if (config.getFlipChanceInPercent() == 100) {
            return true;
        }
        return rnd.nextInt(100) < config.getFlipChanceInPercent();
    }

    public static boolean isServiceIdConfiguredByProperty(String serviceId) {
        List<String> serviceIds = config.getServiceIdsList();
        return serviceIds.contains(serviceId) || serviceIds.contains("*");
    }

    public static void debugOutConfig() {
        System.out.println(config);
    }

    static {
        try {
            config = new ConfigurationObject();
            ConfigurationManager.INSTANCE.configure((Object)config);
        }
        catch (IllegalArgumentException noConfigFound) {
            log.warn("couldn't find configuration for " + ConfigurationInterceptorUtil.class.getSimpleName(), (Throwable)noConfigFound);
        }
    }

    @ConfigureMe(name="availabilitytesting", allfields=true)
    public static class ConfigurationObject {
        private String[] serviceIds = new String[0];
        private long slowDownTimeInMillis = 10000L;
        private List<String> serviceIdsList;
        private int flipChanceInPercent;

        public String[] getServiceIds() {
            return this.serviceIds;
        }

        public void setServiceIds(String[] serviceIds) {
            this.serviceIds = serviceIds;
        }

        public long getSlowDownTimeInMillis() {
            return this.slowDownTimeInMillis;
        }

        public void setSlowDownTimeInMillis(long slowDownTimeInMillis) {
            this.slowDownTimeInMillis = slowDownTimeInMillis;
        }

        public String toString() {
            return "service ids: " + this.getServiceIdsList() + ", slowDownTime: " + this.slowDownTimeInMillis + ", flipChance: " + this.flipChanceInPercent + "/100";
        }

        @AfterConfiguration
        public void setHelper() {
            this.serviceIdsList = this.serviceIds != null ? Collections.unmodifiableList(Arrays.asList(this.serviceIds)) : Collections.EMPTY_LIST;
        }

        @AfterConfiguration
        public void debugOut() {
            System.out.println("availability testing interceptors reconfigured: " + this);
            log.debug("availability testing interceptors reconfigured: " + this);
        }

        public List<String> getServiceIdsList() {
            return this.serviceIdsList;
        }

        public int getFlipChanceInPercent() {
            return this.flipChanceInPercent;
        }

        public void setFlipChanceInPercent(int flipChanceInPercent) {
            if (flipChanceInPercent < 0 || flipChanceInPercent > 100) {
                throw new IllegalArgumentException("flip chance must be between 0 and 100");
            }
            this.flipChanceInPercent = flipChanceInPercent;
        }
    }
}

