/*
 * Decompiled with CFR 0.152.
 */
package org.distributeme.core.interceptor.availabilitytesting;

import java.util.ArrayList;
import java.util.List;
import net.anotheria.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyInterceptorUtil {
    private static final Logger log = LoggerFactory.getLogger(PropertyInterceptorUtil.class);
    private static List<String> serviceIds = PropertyInterceptorUtil.extractServiceIds();

    public static List<String> extractServiceIds() {
        ArrayList<String> propertyValues = new ArrayList<String>();
        String pValue = System.getProperty("availabilityTestingServiceId");
        if (pValue != null && pValue.length() > 0) {
            String[] tokens;
            for (String s : tokens = StringUtils.tokenize((String)pValue, (char)',')) {
                propertyValues.add(s);
            }
        }
        return propertyValues;
    }

    public static final long getSlowDownTime() {
        try {
            String slowDownTimeAsString = System.getProperty("availabilityTestingSlowDownTimeInMillis");
            if (slowDownTimeAsString != null && slowDownTimeAsString.length() > 0) {
                return Long.parseLong(slowDownTimeAsString);
            }
        }
        catch (Exception e) {
            log.warn("Couldn't parse slowdowntime, returning default value 10000", (Throwable)e);
        }
        return 10000L;
    }

    public static boolean isServiceIdConfiguredByProperty(String serviceId) {
        return serviceIds.contains(serviceId) || serviceIds.contains("*");
    }

    public static boolean flip() {
        return false;
    }
}

