/*
 * Decompiled with CFR 0.152.
 */
package org.distributeme.core.interceptor.moskito;

import net.anotheria.moskito.core.calltrace.CurrentlyTracedCall;
import net.anotheria.moskito.core.calltrace.RunningTraceContainer;
import net.anotheria.moskito.core.calltrace.TraceStep;
import net.anotheria.moskito.core.calltrace.TracedCall;
import net.anotheria.moskito.core.producers.IStatsProducer;
import org.distributeme.core.ClientSideCallContext;
import org.distributeme.core.ServerSideCallContext;
import org.distributeme.core.interceptor.ClientSideRequestInterceptor;
import org.distributeme.core.interceptor.InterceptionContext;
import org.distributeme.core.interceptor.InterceptorResponse;
import org.distributeme.core.interceptor.ServerSideRequestInterceptor;
import org.distributeme.core.interceptor.moskito.MoskitoJourneyInterceptorStatsProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoskitoJourneyInterceptor
implements ClientSideRequestInterceptor,
ServerSideRequestInterceptor {
    private static final String CONTEXT_ATTRIBUTE_STEPBACKFROMSERVER = MoskitoJourneyInterceptor.class.getName() + "Step";
    private static final String CONTEXT_ATTRIBUTE_TRACE_FLAG = MoskitoJourneyInterceptor.class.getName() + "TraceFlag";
    private static final String ICONTEXT_ATTRIBUTE_STARTTIME = MoskitoJourneyInterceptor.class.getName() + "Start";
    private static Logger log = LoggerFactory.getLogger(MoskitoJourneyInterceptor.class);

    @Override
    public InterceptorResponse beforeServantCall(ServerSideCallContext context, InterceptionContext iContext) {
        Boolean flag = (Boolean)context.getTransportableCallContext().get(CONTEXT_ATTRIBUTE_TRACE_FLAG);
        if (flag != null && flag.booleanValue()) {
            CurrentlyTracedCall currentTrace = new CurrentlyTracedCall("SERVER_SIDE");
            RunningTraceContainer.setCurrentlyTracedCall((TracedCall)currentTrace);
            currentTrace.startStep("--- NETWORK IN ---", (IStatsProducer)MoskitoJourneyInterceptorStatsProducer.SKELETON);
            iContext.getLocalStore().put(ICONTEXT_ATTRIBUTE_STARTTIME, System.nanoTime());
        }
        return InterceptorResponse.CONTINUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InterceptorResponse afterServantCall(ServerSideCallContext context, InterceptionContext iContext) {
        TracedCall aTracedCall = RunningTraceContainer.getCurrentlyTracedCall();
        if (!aTracedCall.callTraced()) {
            return InterceptorResponse.CONTINUE;
        }
        try {
            CurrentlyTracedCall currentTrace = (CurrentlyTracedCall)aTracedCall;
            try {
                long endTime = (Long)iContext.getLocalStore().get(ICONTEXT_ATTRIBUTE_STARTTIME);
                currentTrace.getCurrentStep().setDuration(System.nanoTime() - endTime);
            }
            catch (Exception e) {
                log.warn("Couldn't detect duration of current call " + currentTrace.getCurrentStep() + " in " + currentTrace, (Throwable)e);
            }
            context.getTransportableCallContext().put(CONTEXT_ATTRIBUTE_STEPBACKFROMSERVER, currentTrace.getCurrentStep());
            context.getTransportableCallContext().remove(CONTEXT_ATTRIBUTE_TRACE_FLAG);
            currentTrace.endStep();
        }
        finally {
            RunningTraceContainer.endTrace();
        }
        return InterceptorResponse.CONTINUE;
    }

    @Override
    public InterceptorResponse beforeServiceCall(ClientSideCallContext context, InterceptionContext iContext) {
        TracedCall aTracedCall = RunningTraceContainer.getCurrentlyTracedCall();
        if (!aTracedCall.callTraced()) {
            return InterceptorResponse.CONTINUE;
        }
        CurrentlyTracedCall currentTrace = (CurrentlyTracedCall)aTracedCall;
        currentTrace.startStep("--- NETWORK OUT ---", (IStatsProducer)MoskitoJourneyInterceptorStatsProducer.NETWORK);
        iContext.getLocalStore().put(ICONTEXT_ATTRIBUTE_STARTTIME, System.nanoTime());
        context.getTransportableCallContext().put(CONTEXT_ATTRIBUTE_TRACE_FLAG, Boolean.TRUE);
        return InterceptorResponse.CONTINUE;
    }

    @Override
    public InterceptorResponse afterServiceCall(ClientSideCallContext context, InterceptionContext iContext) {
        TracedCall aTracedCall = RunningTraceContainer.getCurrentlyTracedCall();
        if (!aTracedCall.callTraced()) {
            return InterceptorResponse.CONTINUE;
        }
        CurrentlyTracedCall currentTrace = (CurrentlyTracedCall)aTracedCall;
        TraceStep fromServer = (TraceStep)context.getTransportableCallContext().get(CONTEXT_ATTRIBUTE_STEPBACKFROMSERVER);
        if (fromServer == null) {
            log.warn("Warning, unexpected null TraceStep in " + currentTrace + " came back from server.");
            return InterceptorResponse.CONTINUE;
        }
        currentTrace.getCurrentStep().addChild(fromServer);
        long endTime = System.nanoTime();
        try {
            long startTime = (Long)iContext.getLocalStore().get(ICONTEXT_ATTRIBUTE_STARTTIME);
            currentTrace.getCurrentStep().setDuration(endTime - startTime);
        }
        catch (Exception e) {
            log.warn("Couldn't detect duration of current call " + currentTrace.getCurrentStep() + " in " + currentTrace, (Throwable)e);
        }
        currentTrace.endStep();
        return InterceptorResponse.CONTINUE;
    }

    static String testGetCONTEXT_ATTRIBUTE_TRACE_FLAGname() {
        return CONTEXT_ATTRIBUTE_TRACE_FLAG;
    }

    static String testGetCONTEXT_ATTRIBUTE_STEPBACKFROMSERVERName() {
        return CONTEXT_ATTRIBUTE_STEPBACKFROMSERVER;
    }
}

