/*
 * Decompiled with CFR 0.152.
 */
package org.distributeme.core.lifecycle;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.distributeme.core.lifecycle.HealthStatus;
import org.distributeme.core.lifecycle.LifecycleAware;
import org.distributeme.core.lifecycle.LifecycleComponent;
import org.distributeme.core.lifecycle.ServiceAdapter;
import org.distributeme.core.lifecycle.ServiceInfo;
import org.slf4j.LoggerFactory;

public enum LifecycleComponentImpl implements LifecycleComponent
{
    INSTANCE;

    private ConcurrentMap<String, ServiceAdapter> publicServices = new ConcurrentHashMap<String, ServiceAdapter>();

    @Override
    public boolean isOnline() {
        return true;
    }

    @Override
    public void printStatusToSystemOut() {
        System.out.println(LifecycleComponent.class + " is online.");
    }

    @Override
    public void printStatusToLogInfo() {
        LoggerFactory.getLogger(LifecycleComponent.class).info(LifecycleComponent.class + " is online.");
    }

    @Override
    public List<String> getPublicServices() {
        ArrayList<String> ret = new ArrayList<String>();
        ret.addAll(this.publicServices.keySet());
        return ret;
    }

    @Override
    public void registerPublicService(String descriptor, ServiceAdapter instance) {
        this.publicServices.put(descriptor, instance);
    }

    @Override
    public ServiceInfo getServiceInfo(String serviceId) {
        ServiceAdapter adapter = (ServiceAdapter)this.publicServices.get(serviceId);
        ServiceInfo info = new ServiceInfo();
        info.setServiceId(serviceId);
        try {
            info.setLastAccessTimestamp(adapter.getLastAccessTimestamp());
            info.setCreationTimestamp(adapter.getCreationTimestamp());
        }
        catch (RemoteException willNeverHappen) {
            throw new AssertionError((Object)"The moon is falling into the sea!");
        }
        return info;
    }

    @Override
    public void shutdown(final String message) {
        new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                System.out.println("Remote shutdown initiated with message: " + message);
                System.exit(0);
            }
        }.start();
    }

    @Override
    public HealthStatus getHealthStatus(String serviceId) {
        ServiceAdapter adapter = (ServiceAdapter)this.publicServices.get(serviceId);
        if (adapter instanceof LifecycleAware) {
            return ((LifecycleAware)((Object)adapter)).getHealthStatus();
        }
        return HealthStatus.OK();
    }

    @Override
    public Map<String, HealthStatus> getHealthStatuses() {
        HashMap<String, HealthStatus> ret = new HashMap<String, HealthStatus>();
        for (String id : this.publicServices.keySet()) {
            ret.put(id, this.getHealthStatus(id));
        }
        return ret;
    }
}

